//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ClientDataSetMoveBy.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  CDS2->LoadFromFile("../CDS2.XML");
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  CDS2->SaveToFile("../CDS2.XML", dfXML);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button5Click(TObject *Sender)
{
  CDS2->Close();
}
//---------------------------------------------------------------------------
/*
The following code creates and activates a client dataset in
the forms OnCreate event handler.
*/ 
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TFieldDefs *pDefs = CDS2->FieldDefs;
  TFieldDef *pDef = pDefs->AddFieldDef();
  pDef->DataType = ftInteger;
  pDef->Name = "Field1";

  pDef = pDefs->AddFieldDef();
  pDef->DataType = ftString;
  pDef->Size = 10;
  pDef->Name = "Field2";

  TIndexDef *pIDef = CDS2->IndexDefs->AddIndexDef();
  pIDef->Fields = "Field1";
  pIDef->Name = "IntIndex";

  CDS2->CreateDataSet();
}
//---------------------------------------------------------------------------
// BeginExample: ClientDataSetMoveBy
// Method: DB.TDataSet.MoveBy
// Property: DBGrids.TCustomDBGrid.SelectedIndex
// Property: Classes.TComponent.Tag

// BeginCode
/*
The following example enables the user to move the current
selected cell in a db grid.  The Up and Down buttons have
their OnClick events assigned to the UpDownClick procedure.
The Left and Right buttons have their OnClick events
assigned to the LeftRightClick procedure.  The Up and Left
buttons have their Tag property set to -1, while the Down
and Right buttons have their Tag property set to 1.  MoveBy
does not move the cell in the db grid, it only moves the
selection.  The data set is not edited.  Notice that the
Up button and the Down button are separate TButtons, not
one TUpDown.  The tags must be set different.
*/
void __fastcall TForm1::UpDownClick(TObject *Sender)
{
  CDS2->MoveBy((dynamic_cast<TComponent *>(Sender))->Tag);
  DBGrid2->SetFocus();
}

void __fastcall TForm1::LeftRightClick(TObject *Sender)
{
  DBGrid2->SelectedIndex = DBGrid2->SelectedIndex + (dynamic_cast<TComponent *>(Sender))->Tag;
  DBGrid2->SetFocus();
}
// EndCode
// EndExample: ClientDataSetMoveBy
//---------------------------------------------------------------------------

