/*
Canvas ClipRect example
This example creates a region and selects this region as the clipping rectangle for the Image component's canvas. It then sets the canvas's brush color to red and calls FillRect using the ClipRect as the area to fill. Lastly, the ClipRect is reset to the original value that it contained by calling SelectClipRect with NULL as the second parameter and deletes the region.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
    HRGN MyRgn;

    MyRgn = ::CreateRectRgn(100,100,200,200);
    ::SelectClipRgn(Image1->Canvas->Handle,MyRgn);
    Image1->Canvas->Brush->Color = clRed;
    Image1->Canvas->FillRect(Image1->Canvas->ClipRect);
    Image1->Invalidate();
    ::SelectClipRgn(Image1->Canvas->Handle,NULL);
    ::DeleteObject(MyRgn);
} 
