//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ComponentCount.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: ComponentCount
// Property: Classes.TComponent.ComponentCount
// Property: Classes.TComponent.Components
// Method: Classes.TComponent.RemoveComponent
// Method: Classes.TComponent.InsertComponent

// BeginCode
/*
This code fragment moves any nonvisual components on the 
form into a separate data module. Note that the components 
are removed starting with the last component, so that the 
unprocessed portion of the Components array does not change.
Note: This code does not save the form or data module to disk
after the nonvisual components are moved.  If executed at 
runtime, the effect will not persist.
Add a second TForm and name it ComponentCount2.  Put 
"#include ComponentCount2.cpp" in ComponentCount.h.  
Place a TMemo in each form and a TButton in Form1.
*/

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  int I;
  TComponent *Temp;
  Memo1->Lines->Add("Components removed: ");
  Form2->Memo1->Lines->Add("Components added: ");
  for (I = ComponentCount - 1; I >= 0; I--)
  {
	Temp = Components[I];
	// only move components that are not controls
    if (dynamic_cast<TControl *>(Temp) == NULL)
    {
	  RemoveComponent(Temp);
	  Memo1->Lines->Add(Temp->Name);
	  Form2->InsertComponent(Temp);
	  Form2->Memo1->Lines->Add(Temp->Name);
	}
  }
}
// EndCode
// EndExample: ComponentCount
//---------------------------------------------------------------------------
