/*
ComponentCount, Components, RemoveComponent, InsertComponent example
This example defines the MoveToModule function, which moves any nonvisual components on the form into a separate data module. Note that the components are removed starting with the last component, so that the unprocessed portion of the Components array does not change.
Note: This code does not save the form or data module to disk after the nonvisual components are moved.  If executed at runtime, the effect will not persist.
*/ 
void MoveToModule(TForm *Source, TDataModule *Dest)
{
  int I;
  TComponent *Temp;
  for (I = Source->ComponentCount - 1; I >= 0; I--)
  {
    Temp = Source->Components[I];
    // only move components that are not controls
    if (dynamic_cast<TControl *>(Temp) == NULL)
    {
      Source->RemoveComponent(Temp);
      Dest->InsertComponent(Temp);
    }
  }
} 
