//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ComponentToString.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: ComponentToString
// Method: Classes.TStream.ReadComponent
// Method: Classes.TStream.WriteComponent
// Property: Classes.TStringStream.DataString
// Routine: Classes.ObjectBinaryToText
// Routine: Classes.ObjectTextToBinary
// Method: Classes.TCustomMemoryStream.Seek
// Method: Classes.TStringStream.Create
// Class: Classes.TMemoryStream
// Class: Classes.TStringStream
// Class: Classes.TStream
// Routine: Classes.RegisterClass

// BeginCode
/*
This example shows how to use the built-in component
streaming support to convert any component into a string and
convert that string back into a component.
*/

#include <memory>       //for STL auto_ptr class

class MyScrollBar : public TScrollBar
{
__published:	// IDE-managed Components
private:	// User declarations
public:		// User declarations
	__fastcall MyScrollBar(TComponent* Owner);
};

__fastcall MyScrollBar::MyScrollBar(TComponent* Owner)
	: TScrollBar(Owner)
{
}

void RegisterClassesWithStreamingSystem(void)
{
  // Make sure that as part of the startup
  // code our streaming classes are registered
  // with the streaming system.

  #pragma startup RegisterClassesWithStreamingSystem

  Classes::RegisterClass(__classid(MyScrollBar));
}

MyScrollBar *ScrollBar1;

AnsiString __fastcall ComponentToString(TComponent *c)
{
  AnsiString as;
  std::auto_ptr<TMemoryStream> pms(new TMemoryStream);
  std::auto_ptr<TStringStream> pss(new TStringStream(as));

  try
  {
	pms->WriteComponent(c);
	pms->Seek(0, soFromBeginning);
	ObjectBinaryToText(pms.get(), pss.get());
    pss->Seek(0, soFromBeginning);
    as = pss->DataString;
  }
  catch(...)
  {
    ShowMessage("Streaming error.");
  }

  return as;
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  Memo1->Text = ComponentToString(ScrollBar1);
}

TComponent *__fastcall StringToComponent(AnsiString as)

{
  std::auto_ptr<TMemoryStream> pms(new TMemoryStream);
  std::auto_ptr<TStringStream> pss(new TStringStream(as));
  TComponent *pc;

  try
  {
	ObjectTextToBinary(pss.get(), pms.get());
    pms->Seek(0, soFromBeginning);
  }
  catch(...)
  {
    ShowMessage("Streaming error.");
  }

  pc = pms->ReadComponent(NULL);
  return pc;
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  TComponent *temp = StringToComponent(Memo1->Text);
  ScrollBar1->Free();

  ScrollBar1 = dynamic_cast<MyScrollBar *>(temp);
  ScrollBar1->Parent = Form1;
  ScrollBar1->Visible = TRUE;
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  ScrollBar1 = new MyScrollBar(Form1);  // Form1 will clean up the scroll bar.
  ScrollBar1->Parent = Form1;
  ScrollBar1->Visible = TRUE;
  ScrollBar1->Top = 48;
  ScrollBar1->Left = 250;
  ScrollBar1->Name = "Ricksbar";
}
// EndCode
// EndExample: ComponentToString
//---------------------------------------------------------------------------
