/*
WriteComponent, Seek, ObjectBinaryToText, DataString, ObjectTextToBinary, ReadComponent Example
This example shows how to use the built-in component streaming support to convert any component into a string and convert that string back into a component.
*/

AnsiString ComponentToString(TComponent c)
{
 AnsiString as;
 TMemoryStream* pms = new TMemoryStream();
 TStringStream* pss = new TStringStream(as);

 try
 {
    pms->WriteComponent(&c);
    pms->Seek(0, soFromBeginning);
    ObjectBinaryToText(pms, pss);
    pss->Seek(0, soFromBeginning);
    as = pss->DataString;
 }
 catch(...)
 {
    ShowMessage("Streaming error.");
 }

 delete pms;
 delete pss;
 return as;
}

TComponent StringToComponent(AnsiString as)
{
 TMemoryStream* pms = new TMemoryStream();
 TStringStream* pss = new TStringStream(as);
 TComponent *pc;

 try
 {
    ObjectTextToBinary(pss, pms);
    pms->Seek(0, soFromBeginning);
 }
 catch(...)
 {
    ShowMessage("Streaming error.");
 }

 pc = pms->ReadComponent(NULL);
 delete pms;
 delete pss;
 return *pc;
} 
