//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ControlMargins.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
	: TForm(Owner)
{
}

//---------------------------------------------------------------------------

// BeginExample: ControlMargins
// Property: Controls.TControl.AlignWithMargins
// Property: Controls.TControl.Margins
// Class: Controls.TMargins
// Method: Controls.TControl.SetBounds

// BeginCode
//
//This example demostrates the usage of Margins and AlignWithMargins
//properties. Note that Margins will only work when AlignWithMargins
//is set to true and Align is not alNone.
//

#define TopPanelMargin 10
#define BottomPanelMargin 20

TPanel *TopPanel, *BottomPanel;

void __fastcall TForm2::FormCreate(TObject *Sender)
{
	/* Create a new panel and align it to top */
	TopPanel = new TPanel(this);
	TopPanel->Parent = this;
	TopPanel->Align = alTop;
	TopPanel->Height = (ClientHeight / 2);

	/* Create a new panel and align it to the remaining client size */
	BottomPanel = new TPanel(this);
	BottomPanel->Parent = this;
	BottomPanel->Align = alClient;

	/* Set Top panel margins */
	/* Note: Margins will not have an effect if Align is alNone */
	TopPanel->Margins->SetBounds(TopPanelMargin, TopPanelMargin,
								 TopPanelMargin, TopPanelMargin);
	TopPanel->AlignWithMargins = true;
	TopPanel->Caption = "TopPanel";

	/* Set Top Bottom margins */
	/* Note: Margins will not have an effect if Align is alNone */
	BottomPanel->Margins->SetBounds(BottomPanelMargin, BottomPanelMargin,
								   BottomPanelMargin, BottomPanelMargin);
	BottomPanel->AlignWithMargins = true;
	BottomPanel->Caption = "BottomPanel";

	if ((TopPanel->Top != TopPanelMargin) ||
	   (TopPanel->Left != TopPanelMargin) ||
	   (TopPanel->Width != (ClientWidth - (TopPanelMargin * 2))) ||
	   (BottomPanel->Top != (TopPanel->Height + (TopPanelMargin * 2) +
											   BottomPanelMargin)) ||
	   (BottomPanel->Left != BottomPanelMargin) ||
	   (BottomPanel->Width != (ClientWidth - (BottomPanelMargin * 2))))
	   {
		  MessageDlg(AnsiString(
			"This should not happen! Position and size are ")+
			"calculated relative to the margins",
			mtError, TMsgDlgButtons() << mbOK, 0);
	   }
}
// EndCode
// EndExample: ControlMargins

void __fastcall TForm2::Button1Click(TObject *Sender)
{
	TPanel *topmargin, *bottommargin, *leftmargin, *rightmargin;

	topmargin = new TPanel(this);
	topmargin->Parent = this;
	topmargin->Left = 0;
	topmargin->Width = ClientWidth;
	topmargin->Top = 0;
	topmargin->Height = TopPanelMargin;
	topmargin->Color = clYellow;
	topmargin->Caption = "topmargin";

	bottommargin = new TPanel(this);
	bottommargin->Parent = this;
	bottommargin->Left = 0;
	bottommargin->Width = ClientWidth;
	bottommargin->Top = ClientHeight - BottomPanelMargin;
	bottommargin->Height = BottomPanelMargin;
	bottommargin->Color = clYellow;
	bottommargin->Caption = "bottommargin";

	leftmargin = new TPanel(this);
	leftmargin->Parent = this;
	leftmargin->Left = 0;
	leftmargin->Width = TopPanelMargin;
	leftmargin->Top = 0;
	leftmargin->Height = TopPanelMargin + TopPanel->Height;
	leftmargin->Color = clYellow;
	leftmargin->Caption = "leftmargin";

	rightmargin = new TPanel(this);
	rightmargin->Parent = this;
	rightmargin->Left = ClientWidth - BottomPanelMargin;
	rightmargin->Width = BottomPanelMargin;
	rightmargin->Top = TopPanelMargin + TopPanel->Height + TopPanelMargin + BottomPanelMargin;
	rightmargin->Height = BottomPanel->Height;
	rightmargin->Color = clYellow;
	rightmargin->Caption = "rightmargin";
}
//---------------------------------------------------------------------------

