//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "CopyMode.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: CopyMode
// Property: Graphics.TCanvas.CopyMode
// Property: Graphics.TCanvas.CopyRect

// BeginCode
/*
The following example uses the CopyMode of an images canvas
to blank out the image when the user chooses the "Cut" menu
item.  This example requires a Main menu with a Copy and a
Cut menu item that have their OnClick error handlers populated.
Note: CopyMode and CopyRect are members of the destination
canvas.
*/
void __fastcall TForm1::Copy1Click(TObject *Sender)
{
	TRect SrcRect, DstRect;
	Image2->Canvas->CopyMode = cmSrcCopy;
	DstRect = Rect(0, 0, Image2->Width, Image2->Height);
	SrcRect = Rect(0, 0, Image1->Width, Image1->Height);
	Image2->Canvas->CopyRect(DstRect, Image1->Canvas, SrcRect);
}

void __fastcall TForm1::Cut1Click(TObject *Sender)
{
 TRect r;
 Copy1Click(Sender); // Do the same thing as the copy menu item.
 Image1->Canvas->CopyMode = cmWhiteness;
 r = Rect(0, 0, Image1->Width, Image1->Height);
 Image1->Canvas->CopyRect(r, Image1->Canvas, r);
 Image1->Canvas->CopyMode = cmSrcCopy; // Restore the copy mode.
}
// EndCode
// EndExample: CopyMode
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Image1->Picture->LoadFromFile(
	"c:/Program Files/Common Files/CodeGear Shared/Images/Splash/256color/factory.bmp");
}
//---------------------------------------------------------------------------
