//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "CreateBlobStream.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
TBlobField *Table1Notes;

  //---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: CreateBlobStream
// Method: DB.TDataSet.CreateBlobStream
// Method: DBTables.TBlobStream.Create
// Method: DB.TDataSet.Edit
// Method: DB.TDataSet.FieldByName
// Method: Classes.TStream.CopyFrom

// BeginCode
/*
The following example copies the data in the Notes field of
Table1 or SQLDataSet1 to the Remarks field of ClientDataSet1.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TBlobType blobType = Table1Notes->BlobType;
  TStream *Stream1 = new TBlobStream(Table1Notes, bmRead);
  try
  {
	CDS2->Edit();
	// heres a different way to create a blob stream }
	TStream *Stream2 = CDS2->CreateBlobStream(CDS2->FieldByName("Remarks"), bmReadWrite);
	try
	{
	  Stream2->CopyFrom(Stream1, Stream1->Size);
//    CDS2.Post;
//    CDS2.Active := True;
	}
	__finally
	{
	  delete Stream2;
	}
  }
  __finally
  {
	delete Stream1;
  }
};
// EndCode
// EndExample: CreateBlobStream

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  //  I : Integer;
  //  S : String;
  //  ft : TFieldType;
  String myString;
  // These properties can also be set statically at design time.
  Table1->DatabaseName = "DBDEMOS";
  Table1->TableName = "MyBlobInfo.DB";
  DataSource1->DataSet = Table1;
  DBGrid1->DataSource = DataSource1;
  Table1->Active = True; // Do this last
  Table1Notes = NULL;
  for (int i = 0; i <= Table1->FieldCount - 1; i++)
  {
	String S = Table1->Fields->Fields[i]->FieldName;
	TFieldType ft = Table1->Fields->Fields[i]->DataType;
	switch (ft)
	{
	  case ftFloat: myString = "float"; break;
	  case ftBoolean: myString = "boolean"; break;
	  case ftInteger: myString = "integer"; break;
	  case ftString: myString = "string"; break;
	  case ftCurrency: myString = "currency"; break;
	  case ftBlob:
	  {
		myString = "blob";
		Table1Notes = dynamic_cast<TBlobField *>(Table1->Fields->Fields[i]);
		break;
	  };
	  case ftSmallint: myString = "smallint"; break;
	  case ftTime: myString = "time"; break;
	  case ftDate: myString = "date"; break;
	  case ftDateTime: myString = "datetime"; break;
	  case ftTypedBinary: myString = "typedBinary"; break;
	  case ftMemo: myString = "memo"; break;
	  case ftGraphic: myString = "graphic"; break;
	  case ftAutoInc: myString = "autoinc"; break;
	  default: myString = "unknown";
	};
	if(myString != "unknown")
	  ListBox1->Items->Add("Field " + S + " is of type: " + myString);
  };
  if (Table1Notes != NULL)
  {
	TFieldDef *newDef = CDS2->FieldDefs->AddFieldDef();
	newDef->DataType = ftInteger;
	newDef->Name = "Field1";
	newDef = CDS2->FieldDefs->AddFieldDef();
	newDef->DataType = ftBlob;
	newDef->Size = 10;
	newDef->Name = "Remarks";
	TIndexDef *newIDef = CDS2->IndexDefs->AddIndexDef();
	newIDef->Name = "IntIndex";
	newIDef->Fields = "Field1";
	CDS2->CreateDataSet();
	DBMemo2->DataField = "Remarks";
  };
}
//---------------------------------------------------------------------------
