
(*
 Delphi Object and Component Reference
 CreateBlobStream, Edit example
The following example copies the data in the Notes field of Table1 or SQLDataSet1 to the Remarks field of ClientDataSet1.
Windows-only:
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TBlobStream *Stream1;
  TStream *Stream2;

  Stream1 = new TBlobStream(Table1Notes, bmRead);
  try
  {
    ClientDataSet1->Edit();
    // heres another way to create a blob stream
    Stream2 = ClientDataSet1->CreateBlobStream(ClientDataSet1->FieldByName("Remarks"), bmReadWrite);
    try
    {
      Stream2->CopyFrom(Stream1, Stream1->Size);
      ClientDataSet1->Post();
    }
    __finally
    {
      delete Stream2;
    }
  }
  __finally
  {
    delete Stream1;
  }
}
Cross-platform:
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TStream *Stream1, *Stream2;

  Stream1 = SQLDataSet1->CreateBlobStream(SQLDataSet1->FieldByName("Notes"), bmRead);
  try
  {
    ClientDataSet1->Edit();
    Stream2 = ClientDataSet1->CreateBlobStream(ClientDataSet1->FieldByName("Remarks"), bmReadWrite);
    try
    {
      Stream2->CopyFrom(Stream1, Stream1->Size);
      ClientDataSet1->Post();
    }
    __finally
    {
      delete Stream2;
    }
  }
  __finally
  {
    delete Stream1;
  }
}
 
