//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "CreateTable.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
#include <DBTables.hpp>
TForm1 *Form1;
TTable *Table1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: CreateTable
// Method: DBTables.TTable.CreateTable
// Method: DBTables.TTable.DeleteTable
// Property: DBTables.TTable.Exists
// Property: DB.TDataSet.FieldDefs
// Property: DB.TFieldDef.DataType
// Property: DB.TFieldDef.Required
// Property: DB.TFieldDef.Size
// Property: DB.TIndexDef.Fields
// Property: DB.TIndexDef.Options
// Property: DB.TNamedItem.Name
// Method: DB.TDataSet.AppendRecord

// BeginCode
/*
The following example shows how to create a table.
*/

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Table1 = new TTable(Form1);
  Table1->Active = false; // The Table component must not be active
  Table1->DatabaseName = "DBDEMOS";
  Table1->TableType = ttParadox;
  Table1->TableName = "CustInfo";
  if (Table1->Exists)
	MessageDlg("CustInfo table already exists.", mtWarning, TMsgDlgButtons() << mbOK, 0);
  else // Don't overwrite an existing table
  {
	// describe the fields in the table
	Table1->FieldDefs->Clear();
	TFieldDef *newDef = Table1->FieldDefs->AddFieldDef();
	newDef->Name = "Field1";
	newDef->DataType = ftInteger;
	newDef->Required = true;
	newDef = Table1->FieldDefs->AddFieldDef();
	newDef->Name = "Field2";
	newDef->DataType = ftString;
	newDef->Size = 30;
	// Next, describe any indexes
	Table1->IndexDefs->Clear();
	/* the 1st index has no name because it is a Paradox primary key */
	Table1->IndexDefs->Add("","Field1", TIndexOptions() <<ixPrimary << ixUnique);
	Table1->IndexDefs->Add("Fld2Index", "Field2", TIndexOptions() << ixCaseInsensitive);
	// Now that we have specified what we want, create the table
	Table1->CreateTable();
	Table1->Active = True;
	for (int i = 1; i <= 20; i++)
	  Table1->AppendRecord(ARRAYOFCONST((i*111, i*222)));
  }
  DS2->DataSet = Table1;
  DBGrid2->DataSource->DataSet = Table1;
  Table1->Active = True;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  Table1->Close();
  Table1->DeleteTable();
}
// EndCode
// EndExample: CreateTable
//---------------------------------------------------------------------------
