//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "D7ComboBox.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: D7ComboBox
// Property: ComCtrls.TCustomListView.ViewStyle
// Property: ComCtrls.TCustomListView.Column
// Property: ComCtrls.TCustomListView.Items
// Property: ComCtrls.TCustomListView.SmallImages
// Property: ComCtrls.TCustomListView.LargeImages
// Property: ComCtrls.TListItem.ImageIndex
// Method: Classes.TStrings.AddObject
// Method: Classes.TStrings.Objects
// Property: StdCtrls.TCustomCombo.Items
// Property: ImgList.TCustomImageList.Count
// Type: ComCtrls.TViewStyle

// BeginCode

/*
This example requires a TListView, a TImageList and a 
TComboBox. You will need to double click the image list and 
add several images to the image list prior to running the 
project. During the forms OnCreate event 
handler, items for the List View control are created for 
each image in the Image List and the ImageIndex is assigned 
the number of the image within the ImageList. Two columns are
created so that when ViewStyle is vsReport, you will have
columns to view.  Also within the forms OnCreate event 
handler assign the ComboBox each of the four TViewStyle 
constants to the Items Objects property. You could also 
simply code this within a series of OnClick event handlers 
as, for instance, ListView1.->ViewStyle := vsIcon.
*/
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TListItem *Item;
  TListColumn *Column;
  const char imagenames[3][20] = {"C++ Image", "Borland Image", "Delphi Image"};
  const char Col2Array[3][40] = {"Documentation for the C++ icon.", "Borland icon.", "Delphi icon."};
  // Create a ListView item for each image in the ImageList
  ListView1->SmallImages = ImageList1;
  ListView1->LargeImages = ImageList1;
  for (int i = 0; i < ImageList1->Count; i++)
  {
	Item = ListView1->Items->Add();
	Item->Caption = imagenames[i];
	Item->ImageIndex = i;
	Item->SubItems->Add(Col2Array[i]);
  }
  // Create two columns to show during viewing as vsReport
  Column = ListView1->Columns->Add();
  Column->Caption = "Column 1";
  Column->Width = 200;
  Column = ListView1->Columns->Add();
  Column->Caption = "Column 2";
  Column->Width = 200;
  // Add View styles and constants to the Combo Box
  ComboBox1->Items->AddObject("vsIcon", reinterpret_cast<TObject *>(vsIcon));
  ComboBox1->Items->AddObject("vsList", reinterpret_cast<TObject *>(vsList));
  ComboBox1->Items->AddObject("vsReport", reinterpret_cast<TObject *>(vsReport));
  ComboBox1->Items->AddObject("vsSmallIcon", reinterpret_cast<TObject *>(vsSmallIcon));
  // Display first item in the Combo Box
  ComboBox1->ItemIndex = 0;
}

void __fastcall TForm1::ComboBox1Click(TObject *Sender)
{
  ListView1->ViewStyle = (TViewStyle) ComboBox1->Items->Objects[ComboBox1->ItemIndex];
}
// EndCode
// EndExample: D7ComboBox
//---------------------------------------------------------------------------
