/*
Column, Items, ViewStyle, SmallImages, LargeImages, ImageIndex, AddObject, Objects example
This example requires a TListView, a TImageList and a TComboBox. You will need to double click the image list and add several images to the image list prior to running the project. You can use *.bmp or *.ico files from the \Images\Icons directory.
During the forms OnCreate event handler, items for the List View control are created for each image in the Image List and the ImageIndex is assigned the number of the image within the ImageList. Two columns are created so that when ViewStyle is vsReport, you will have columns to view.
Also within the forms OnCreate event handler assign the ComboBox each of the four TViewStyle constants to the Items Objects property. You could also simply code this within a series of OnClick event handlers as, for instance, ListView1.->ViewStyle := vsIcon. 
*/ 
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TListItem!AL(`tlistitem_object',1,`TopicNotFound',`main') *pItem;
  TListColumn!AL(`tlistcolumn_object',1,`TopicNotFound',`main') *pColumn;
  // Create a ListView item for each image in the ImageList
  ListView1->SmallImages = ImageList1;
  ListView1->LargeImages = ImageList1;
  for (int i = 0; i < ImageList1->Count; i++)
  {
    pItem = ListView1->Items->Add();
    pItem->Caption = "Image" + IntToStr(i);
    pItem->ImageIndex = i;
  }
  // Create two columns to show during viewing as vsReport
  pColumn = ListView1->Columns->Add();
  pColumn->Caption = "Column 1";
  pColumn = ListView1->Columns->Add();
  pColumn->Caption = "Column 2";
  // Add View styles and constants to the Combo Box
  ComboBox1->Items->AddObject("vsIcon", (TObject *)vsIcon);
  ComboBox1->Items->AddObject("vsList", (TObject *)vsList);
  ComboBox1->Items->AddObject("vsReport", (TObject *)vsReport);
  ComboBox1->Items->AddObject("vsSmallIcon", (TObject *)vsSmallIcon);
  // Display first item in the Combo Box
  ComboBox1->ItemIndex = 0;
}
void __fastcall TForm1::ComboBox1Click(TObject *Sender)
{
  ListView1->ViewStyle = (TViewStyle) ComboBox1->Items->Objects[ComboBox1->ItemIndex];
}
 
