/*
OnUnDock, DockSite, DockClientCount example
The following example shows how the OnUnDock event handler of the conjoinment docking site re-enables docking in the control that is undocked (if it is a dockable form). In addition, when the next to last docked control is undocked, the conjoinment docking site sends itself a close message so that the last docked control is undocked to its old position and size.
*/ 
void __fastcall TConjoinDockHost::FormUnDock(TObject *Sender, TControl *Client, TWinControl *NewTarget, bool &Allow)
{
  //only 2 dock clients means the host must be destroyed and
  //the remaining window undocked to its old position and size.
  //(Recall that OnUnDock gets called before the undocking actually occurs)
  if (Client->InheritsFrom(__classid(TDockableForm))
    ((TDockableForm *)Client)->DockSite = true;
  if ((DockClientCount == 2) && (NewTarget != (TWinControl *)&this))
    PostMessage(Handle, WM_CLOSE, 0, 0);
  UpdateCaption(Client);
}
 
