//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "uConjoinHost.h"
#include "uDockForm.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TConjoinDockHost *ConjoinDockHost;
//---------------------------------------------------------------------------
__fastcall TConjoinDockHost::TConjoinDockHost(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall  TConjoinDockHost::DoFloat(TControl *AControl)
{
  // Float the control with its original size.
  Types::TPoint TopLeft = AControl->ClientToScreen(Point(0, 0));
  Types::TPoint BottomRight = AControl->ClientToScreen(Point(AControl->UndockWidth,
                       AControl->UndockHeight));

  AControl->ManualFloat(Types::TRect(TopLeft, BottomRight));
}
//---------------------------------------------------------------------------
void __fastcall TConjoinDockHost::FormClose(TObject *Sender,
	  TCloseAction &Action)
{
  if (DockClientCount == 1)
  {
	DoFloat(DockClients[0]);
	Action = caFree;
  }
  else
	Action = caHide;
}
//---------------------------------------------------------------------------
void __fastcall TConjoinDockHost::UpdateCaption(TControl *Exclude)
{
  //if a dockable form is undocking, it will pass itself in as Exclude
  //because even it hasn't actually been taken out of the DockClient array
  //at this point.
  Caption = "";
  for (int I = 0; I <= DockClientCount - 1; I++)
	if (DockClients[I]->Visible && (DockClients[I] != Exclude))
	  Caption = Caption + (dynamic_cast<TDockableForm *>(DockClients[I])->Caption) + " ";
}
//---------------------------------------------------------------------------

void __fastcall TConjoinDockHost::FormDockDrop(TObject *Sender,
      TDragDockObject *Source, int X, int Y)
{
  UpdateCaption(NULL);
  DockManager->ResetBounds(True);
  //Force DockManager to redraw it's clients.
}
//---------------------------------------------------------------------------

// BeginExample: Docking
// Event: Controls.TWinControl.OnUnDock
// Property: Controls.TWinControl.DockSite
// Property: Controls.TWinControl.DockClientCount

// BeginCode
/*
The following example is taken from the docking demo. It
shows how the OnUnDock event handler of the conjoinment
docking site re-enables docking in the control that is
undocked (if it is a dockable form). In addition, when the
next to last docked control is undocked, the conjoinment
docking site sends itself a close message so that the last
docked control is undocked to its old position and size.
*/
void __fastcall TConjoinDockHost::FormUnDock(TObject *Sender, TControl *Client,
      TWinControl *NewTarget, bool &Allow)
{
  // Only 2 dock clients means the host must be destroyed and
  // the remaining window undocked to its old position and size.
  // Recall that OnUnDock gets called before the undocking
  // actually occurs.
  if (Client->ClassNameIs("TDockableForm"))
	dynamic_cast<TDockableForm *>(Client)->DockSite = True;
  if ((DockClientCount == 2) && (NewTarget != this))        // Self?
	PostMessage(dynamic_cast<TConjoinDockHost *>(this)->Handle, WM_CLOSE, 0, 0);
  UpdateCaption(Client);
}
// EndCode
// EndExample: Docking
//---------------------------------------------------------------------------

void __fastcall TConjoinDockHost::FormDockOver(TObject *Sender,
      TDragDockObject *Source, int X, int Y, TDragState State, bool &Accept)
{
  Accept = Source->Control->ClassNameIs("TDockableForm");
}
//---------------------------------------------------------------------------

void __fastcall TConjoinDockHost::FormGetSiteInfo(TObject *Sender,
      TControl *DockClient, TRect &InfluenceRect, TPoint &MousePos,
      bool &CanDock)
{
  CanDock = DockClient->ClassNameIs("TDockableForm");
}
//---------------------------------------------------------------------------

