//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "uTabHost.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TTabDockHost *TabDockHost;
//---------------------------------------------------------------------------
__fastcall TTabDockHost::TTabDockHost(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: UnDock
// Property: Controls.TControl.UndockHeight
// Property: Controls.TControl.UndockWidth
// Method: Controls.TControl.ManualFloat
// Property: Controls.TWinControl.DockClients

// BeginCode
/*
This example shows how to undock a dockable object.  This example
is part of the Docking Demo.
*/

void __fastcall TTabDockHost::FormClose(TObject *Sender, TCloseAction &Action)
{
  TRect ARect;
  TPoint point;
  if (PageControl1->DockClientCount == 1)
  {
	point =  PageControl1->DockClients[0]->ClientToScreen(Point(0, 0));
	ARect.left = point.x;
	ARect.top = point.y;
	point = PageControl1->DockClients[0]->ClientToScreen(
	  Point(PageControl1->DockClients[0]->UndockWidth, PageControl1->DockClients[0]->UndockHeight));
	ARect.right = point.x;
	ARect.bottom = point.y;
	PageControl1->DockClients[0]->ManualFloat(ARect);
	Action = caFree;
  }
  else
	Action = caHide;
}
// EndCode
// EndExample: UnDock
//---------------------------------------------------------------------------

void __fastcall TTabDockHost::PageControl1UnDock(TObject *Sender,
      TControl *Client, TWinControl *NewTarget, bool &Allow)
{
  //only 2 dock clients means the host must be destroyed and
  //the remaining window undocked to its old position and size.
  if ((PageControl1->DockClientCount == 2) && (NewTarget != this))
	PostMessage(this->Handle, WM_CLOSE, 0, 0);
}
//---------------------------------------------------------------------------

void __fastcall TTabDockHost::PageControl1GetSiteInfo(TObject *Sender,
      TControl *DockClient, TRect &InfluenceRect, TPoint &MousePos,
      bool &CanDock)
{
  CanDock = DockClient->ClassNameIs("TDockableForm");
}
//---------------------------------------------------------------------------

void __fastcall TTabDockHost::PageControl1DockOver(TObject *Sender,
      TDragDockObject *Source, int X, int Y, TDragState State, bool &Accept)
{
  Accept = Source->Control->ClassNameIs("TDockableForm");
}
//---------------------------------------------------------------------------


