//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "DrawGridCol.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: DrawGridCol
// Property: Grids.TCustomGrid.Col

// BeginCode
/*
The following code uses the bitmaps in an image list
component to draw the contents of each cell in a draw grid.
It uses a draw grid with a label above it on a form. When
the user clicks a cell in the grid, the location of the
cursor is displayed in the label caption. This example
requires a populated image list, or can just display an
empty grid.
*/
void __fastcall TForm1::DrawGrid1Click(TObject *Sender)
{
  Label1->Caption = "From OnClick: The cursor is in column " +
					 IntToStr(DrawGrid1->Col + 1) +
                     ", row " +
                     IntToStr(DrawGrid1->Row + 1);
}

void __fastcall TForm1::DrawGrid1DrawCell(TObject *Sender, int ACol, int ARow, TRect &Rect,
          TGridDrawState State)
{
  int index = ARow * DrawGrid1->ColCount + ACol;
  DrawGrid1->Canvas->Brush->Color = clBackground;
  DrawGrid1->Canvas->FillRect(Rect);
  ImageList1->Draw(DrawGrid1->Canvas, Rect.Left, Rect.Top, index, True);
  if (State.Contains(gdFocused))
  {
	DrawGrid1->Canvas->DrawFocusRect(Rect);
	Label2->Caption = "From OnDrawCell: Cell " + IntToStr(index) +
	  " has the focus.";
  }
}

void __fastcall TForm1::DrawGrid1SelectCell(TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
  CanSelect = True;
}
// EndCode
// EndExample: DrawGridCol
//---------------------------------------------------------------------------
