//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "DrawGridSelection.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: DrawGridSelection
// Property: Grids.TCustomGrid.Selection

// BeginCode
/*
The following code selects the rectangle containing rows 1
through 4, and columns 2 and 3.  goRangeSelect in the
DrawGrid Options parameter must be True to select a range of
cells.  This example requires a button, a DrawGrid and a
populated ImageList.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TGridRect myRect;
  myRect.Left = 3;
  myRect.Top = 1;
  myRect.Right = 2;
  myRect.Bottom = 4;
  DrawGrid1->Selection = myRect;
  DrawGrid1->Repaint();
}

void __fastcall TForm1::DrawGrid1Click(TObject *Sender)
{
  Label1->Caption = "From OnClick: The cursor is in column " +
					 IntToStr(DrawGrid1->Col + 1) +
                     ", row " +
					 IntToStr(DrawGrid1->Row + 1);
}

void __fastcall TForm1::DrawGrid1DrawCell(TObject *Sender, int ACol, int ARow, TRect &Rect,
          TGridDrawState State)
{
  int index = (ARow * DrawGrid1->ColCount + ACol) % (DrawGrid1->ColCount + 1);
  if (State.Contains(gdSelected))
	DrawGrid1->Canvas->Brush->Color = clYellow;
  else
	DrawGrid1->Canvas->Brush->Color = clBackground;
  DrawGrid1->Canvas->FillRect(Rect);
  if (State.Contains(gdFocused))
  {
	DrawGrid1->Canvas->DrawFocusRect(Rect);
	Label2->Caption = "From OnDrawCell: Cell " + IntToStr(ARow * DrawGrid1->ColCount + ACol) +
	  " has the focus.";
  }
  ImageList1->Draw(DrawGrid1->Canvas, Rect.Left, Rect.Top, index, True);
}

void __fastcall TForm1::DrawGrid1SelectCell(TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
  CanSelect = True;
}
// EndCode
// EndExample: DrawGridSelection
//---------------------------------------------------------------------------

