//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "DrawGridTopRow.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: DrawGridTopRow
// Property: Grids.TCustomGrid.TopRow

// BeginCode
/*
This code uses a draw grid and a button on a form. When
the user clicks the button, the last row of the draw
grid becomes the top row.  This example requires a
button, a DrawGrid and a populated ImageList.
*/

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  DrawGrid1->TopRow = DrawGrid1->RowCount - 1;
}

void __fastcall TForm1::DrawGrid1Click(TObject *Sender)
{
  Label1->Caption = "From OnClick: The cursor is in column " +
					 IntToStr(DrawGrid1->Col + 1) +
                     ", row " +
                     IntToStr(DrawGrid1->Row + 1);
}

void __fastcall TForm1::DrawGrid1DrawCell(TObject *Sender, int ACol, int ARow, TRect &Rect,
          TGridDrawState State)
{
  int index = (ARow * DrawGrid1->ColCount + ACol) % (DrawGrid1->ColCount + 1);
  if (State.Contains(gdSelected))
	DrawGrid1->Canvas->Brush->Color = clYellow;
  else
	DrawGrid1->Canvas->Brush->Color = clBackground;
  DrawGrid1->Canvas->FillRect(Rect);
  if (State.Contains(gdFocused))
  {
	DrawGrid1->Canvas->DrawFocusRect(Rect);
	Label2->Caption = "From OnDrawCell: Cell " + IntToStr(ARow * DrawGrid1->ColCount + ACol) +
	  " has the focus.";
  }
  if ((ARow >=  DrawGrid1->FixedRows) && (ACol >=  DrawGrid1->FixedCols))
	ImageList1->Draw(DrawGrid1->Canvas, Rect.Left, Rect.Top, index, True);
}

void __fastcall TForm1::DrawGrid1SelectCell(TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
  CanSelect = True;
}
// EndCode
// EndExample: DrawGridTopRow
//---------------------------------------------------------------------------

