//--------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "EditMaskExample.h"
//--------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//--------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
}
//--------------------------------------------------------------------

// BeginExample: EditMask
// Property: Mask.TCustomMaskEdit.EditMask
// Property: Mask.TCustomMaskEdit.Text
// Event: Controls.TWinControl.OnExit

// BeginCode
/*
This example uses three mask edit components on a form,
where the third mask edit box is set to be read only.
When the application runs, it initializes the mask edit boxes
to contain the empty string, to use the Courier font and to
use a particular mask, corresponding to IP address coding convetions.
The mask edit boxes display the IP address, the subnet mask
and the subnet address correspondingly. When the user exits the
subnet mask edit box, the subnet address is automatically calculated
using bit-wise AND operations and displayed in the third mask edit box.
An additional test is made to assure that the values in the IP address
and in the subnet mask are in the interval from 0 to 255 ,
as this validation test cannot be accomplished
using the edit mask property alone.
*/
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // initialize the maskedit boxes to contain the empty string
  MaskEdit1->Text = "";
  MaskEdit2->Text = "";
  MaskEdit3->Text = "";

  // use the Courier font in the maskedit boxes
  MaskEdit1->Font->Name = "Courier";
  MaskEdit2->Font->Name = "Courier";
  MaskEdit3->Font->Name = "Courier";

  // initialize the mask of each maskedit box
  // according to IP address coding conventions
  MaskEdit1->EditMask = "!099.099.099.099;1; ";
  MaskEdit2->EditMask = "!099.099.099.099;1; ";
  MaskEdit3->EditMask = "!099.099.099.099;1; ";

  MaskEdit2->OnExit = MaskEdit2Exit;
}

void __fastcall TForm1::MaskEdit2Exit(TObject *Sender)
{
  // extract the net and host address from the IP
  String IP = MaskEdit1->Text;
  int net1 = IP.SubString(0, 3).TrimRight().ToInt();
  int net2 = IP.SubString(5, 3).TrimRight().ToInt();
  int host1 = IP.SubString(9, 3).TrimRight().ToInt();
  int host2 = IP.SubString(13, 3).TrimRight().ToInt();

  // a range test that you cannot validate through edit masks
  if (net1 < 0 || net1 > 255 ||
      net2 < 0 || net2 > 255 ||
      host1 < 0 || host1 > 255 ||
      host2 < 0 || host2 > 255)
    throw(Exception("Not a valid IP address."));

  // extract the net and host mask from the subnet mask
  String mask = MaskEdit2->Text;
  int netmask1 = mask.SubString(0, 3).TrimRight().ToInt();
  int netmask2 = mask.SubString(5, 3).TrimRight().ToInt();
  int hostmask1 = mask.SubString(9, 3).TrimRight().ToInt();
  int hostmask2 = mask.SubString(13, 3).TrimRight().ToInt();

  // a range test that you cannot validate through edit masks
  if (netmask1 < 0 || netmask1 > 255 ||
      netmask2 < 0 || netmask2 > 255 ||
      hostmask1 < 0 || hostmask1 > 255 ||
      hostmask2 < 0 || hostmask2 > 255)
    throw(Exception("Not a valid subnet mask."));

  // compute the subnet address using bit-wise AND
  int sub_net1 = net1 & netmask1;
  int sub_net2 = net2 & netmask2;
  int sub_host1 = host1 & hostmask1;
  int sub_host2 = host2 & hostmask2;

  // display the subnet address
  MaskEdit3->Text =
    String(sub_net1) + "." + String(sub_net2) + "." +
    String(sub_host1) + "." + String(sub_host2);
}
// EndCode
// EndExample: EditMask
