//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ExeName.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: ExeName
// Property: Forms.TApplication.ExeName
// Method: Classes.TStream.CopyFrom
// Routine: SysUtils.ExtractFilePath
// Routine: SysUtils.Format
// Routine: AnsiStrings.Format
// Variable: Forms.Application

// BeginCode
/*
This example copies a specified old file to a new file.  Add
a TSaveDialog to the form.  Also add two TEdits, two TLabels
and a TButton with the OnClick event named Save1Click. Change
the Old Path and New Path to move files outside the Debug
directory, Old File and New File will not take a relative path.
*/

#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Save1Click(TObject *Sender)
{
  AnsiString temp1 = Edit4->Text;
  AnsiString temp2 = ExtractFileName(Edit1->Text);
  AnsiString NewFileName = temp1 + temp2;
  AnsiString OldFileName =
	Edit3->Text + ExtractFileName(Edit2->Text);
  AnsiString Msg = Format("Copy %s to %s", ARRAYOFCONST((OldFileName, NewFileName)));
  if (MessageDlg(Msg, mtCustom, TMsgDlgButtons() << mbOK << mbCancel, 0) == mrOk)
  {
	std::auto_ptr<TFileStream> OldFile(new TFileStream(OldFileName, fmOpenRead | fmShareDenyWrite));
	std::auto_ptr<TFileStream> NewFile(new TFileStream(NewFileName, fmCreate | fmShareDenyRead));
	NewFile->CopyFrom(OldFile.get(), OldFile->Size);
  }
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Edit3->Text = ExtractFilePath(Application->ExeName);
  Edit4->Text = Edit3->Text;
}
// EndCode
// EndExample: ExeName
//---------------------------------------------------------------------------

