/*
CopyFrom, ExeName, ExtractFilePath, Format example
This example copies a specified file into the same directory as the (cross-platform) application.
*/ 
void __fastcall TForm1::Save1Click(TObject *Sender)
{
  AnsiString NewFileName = ExtractFilePath(Application->ExeName) + ExtractFileName(Edit1->Text);
  AnsiString Msg = Format("Copy %s to %s", ARRAYOFCONST((Edit1->Text,NewFileName)));
  if (MessageDlg(Msg, mtCustom, mbOKCancel, 0) == mrOK)
  {
    TFileStream *OldFile = new TFileStream(Edit1->Text, fmOpenRead);
    try
    {
      TFileStream *NewFile = new TFileStream(NewFileName, fmCreate);
      try
      {
        NewFile->CopyFrom(OldFile, OldFile->Size);
      }
      __finally
      {
        FreeAndNil(NewFile);
      }
    }
    __finally
    {
      FreeAndNil(OldFile);
    }
  }
} 
