//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ExtractFileName.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: ExtractFileName
// Routine: SysUtils.FileExists
// Routine: SysUtils.RenameFile
// Routine: SysUtils.FileCreate
// Routine: SysUtils.FileWrite
// Routine: SysUtils.FileClose

// BeginCode
/*
The following example uses a button, a string grid, and a
Save dialog box on a form. When the button is clicked, the
user is prompted for a filename. When the user clicks OK,
the contents of the string grid are written to the specified
file. Additional information is also written to the file so
that it can be read easily with the FileRead function. Verify
the file written after executing.
*/

#include <dir.h>

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  char szFileName[MAXFILE+4];
  int iFileHandle;
  int iLength;
  if (SaveDialog1->Execute())
  {
    if (FileExists(SaveDialog1->FileName))
    {
	  fnsplit(AnsiString(SaveDialog1->FileName).c_str(), 0, 0, szFileName, 0);
	  strcat(szFileName, ".BAK");
      RenameFile(SaveDialog1->FileName, szFileName);
    }
    iFileHandle = FileCreate(SaveDialog1->FileName);
    // Write out the number of rows and columns in the grid.
	FileWrite(iFileHandle, reinterpret_cast<char *>(&(StringGrid1->ColCount)), sizeof(StringGrid1->ColCount));
	FileWrite(iFileHandle, reinterpret_cast<char *>(&(StringGrid1->RowCount)), sizeof(StringGrid1->RowCount));
    for (int x=0;x<StringGrid1->ColCount;x++)
    {
      for (int y=0;y<StringGrid1->RowCount;y++)
      {
        // Write out the length of each string, followed by the string itself.
        iLength = StringGrid1->Cells[x][y].Length();
        FileWrite(iFileHandle, reinterpret_cast<char *>(&iLength), sizeof(iLength));
        FileWrite(iFileHandle, StringGrid1->Cells[x][y].t_str(), StringGrid1->Cells[x][y].Length());
      }
    }
    FileClose(iFileHandle);
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  StringGrid1->Cells[1][0] = "Column 1";
  StringGrid1->Cells[2][0] = "Column 2";
  StringGrid1->Cells[3][0] = "Column 3";
  StringGrid1->Cells[4][0] = "Column 4";
  StringGrid1->Cells[0][1] = "Row 1";
  StringGrid1->Cells[1][1] = "Object";
  StringGrid1->Cells[2][1] = "Pascal";
  StringGrid1->Cells[3][1] = "is";
  StringGrid1->Cells[4][1] = "excellent";
  StringGrid1->Cells[0][2] = "Row 2";
  StringGrid1->Cells[1][2] = "Delphi";
  StringGrid1->Cells[2][2] = "is";
  StringGrid1->Cells[4][2] = "RAD";
};
// EndCode
// EndExample: ExtractFileName
//---------------------------------------------------------------------------
