//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FetchParams.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  CDS->LoadFromFile(GetCurrentDir() + "\\..\\CDS.XML");
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  CDS->SaveToFile(GetCurrentDir() + "\\..\\CDS.XML", dfXML);
}

void __fastcall TForm1::Button3Click(TObject *Sender)
{
  CDS->CreateDataSet();
}

void __fastcall TForm1::Button4Click(TObject *Sender)
{
  CDS2->Data = CDS->Data;
}

void __fastcall TForm1::Button5Click(TObject *Sender)
{
  CDS->Close();
}

// BeginExample: FetchParams
// Method: DBClient.TCustomClientDataSet.FetchParams
// Property: DBClient.TCustomClientDataSet.Params
// Property: DB.TParam.DataType
// Property: DB.TParams.Items

// BeginCode
/*
  This example saves params from a ClientDataSet, alters them
  and restores them.
*/
TParams *SavedParams;

void __fastcall TForm1::SaveParamsClick(TObject *Sender)
{
  // Save the parameters for the TDataSet
  SavedParams->Assign(CDS->Params);
}

void __fastcall TForm1::AlterParamsClick(TObject *Sender)
{
  CDS->Params->CreateParam(ftString, "stringParam", ptInput);  // you can also edit the params in the CDS dynamically
  CDS->Params->CreateParam(ftSmallint, "smallIntParam", ptInput);
  CDS->Params->CreateParam(ftInteger, "intParam", ptInput);
  CDS->Params->CreateParam(ftWord, "wordParam", ptInput);
  CDS->Params->CreateParam(ftBoolean, "boolParam", ptInput);
  CDS->Params->CreateParam(ftFloat, "floatParam", ptInput);
  CDS->Params->CreateParam(ftCurrency, "currencyParam", ptInput);
  CDS->Params->CreateParam(ftBCD, "bcdParam", ptInput);
  CDS->Params->CreateParam(ftDate, "dateParam", ptInput);
  CDS->Params->CreateParam(ftTime, "timeParam", ptInput);
  CDS->Params->CreateParam(ftDateTime, "dateTimeParam", ptInput);
  // Call FetchParams to ensure parameters reflect server metadata
  CDS->FetchParams();
//  with CDS->Params do
  for (int I = 0; I < CDS->Params->Count; I++)
  {
	AnsiString ListItem = ListBox1->Items->Strings[I];
	switch (CDS->Params->Items[I]->DataType)
	{
	  case ftString:
		CDS->Params->Items[I]->AsString = ListItem; break;
	  case ftSmallint:
		CDS->Params->Items[I]->AsSmallInt = StrToIntDef(ListItem, 0); break;
	  case ftInteger:
		CDS->Params->Items[I]->AsInteger = StrToIntDef(ListItem, 0); break;
	  case ftWord:
		CDS->Params->Items[I]->AsWord = StrToIntDef(ListItem, 0); break;
	  case ftBoolean:
		CDS->Params->Items[I]->AsBoolean = (ListItem == "True"); break;
	  case ftFloat:
		CDS->Params->Items[I]->AsFloat = StrToFloat(ListItem); break;
	  case ftCurrency:
		CDS->Params->Items[I]->AsCurrency = double(StrToFloat(ListItem)); break;
	  case ftBCD:
		CDS->Params->Items[I]->AsBCD = StrToCurr(ListItem); break;
	  case ftDate:
		CDS->Params->Items[I]->AsDate = StrToDate(ListItem); break;
	  case ftTime:
		CDS->Params->Items[I]->AsTime = StrToTime(ListItem); break;
	  case ftDateTime:
		CDS->Params->Items[I]->AsDateTime = StrToDateTime(ListItem); break;
	}
  }
}

void __fastcall TForm1::RestoreParamsClick(TObject *Sender)
{
  // Restore the parameters to TDataSet
  CDS->Params->AssignValues(SavedParams);
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // Initialize SavedParams
  SavedParams = new TParams;
  ListBox1->Items->Add("Here is a string");
  ListBox1->Items->Add("4");
  ListBox1->Items->Add("3456789");
  ListBox1->Items->Add("34");
  ListBox1->Items->Add("0");
  ListBox1->Items->Add("12.56");
  ListBox1->Items->Add("4.23");
  ListBox1->Items->Add("99.5");
  ListBox1->Items->Add("4/12/53");
  ListBox1->Items->Add("7:45:00");
  ListBox1->Items->Add("4/12/53 7:45:00");
}
// EndCode
// EndExample: FetchParams
//---------------------------------------------------------------------------
