
(*
 Delphi Object and Component Reference
 ParamCount, DataType, StrToIntDef, AsXXX example
This example fills in the parameters of a query from the entries of a list box.
*) 
for (int i = 0; i < Query1->ParamCount; i++)
{
  AnsiString ListItem = ListBox1->Items->Strings[i];
  TParam *pParam = Query1->Params->Items[i];
  switch (pParam->DataType)
  {
    case ftString:
        pParam->AsString = ListItem;
        break;
    case ftSmallint:
        pParam->AsSmallInt = StrToIntDef(ListItem, 0);
        break;
    case ftInteger:
        pParam->AsInteger = StrToIntDef(ListItem, 0);
        break;
    case ftWord:
        pParam->AsWord = StrToIntDef(ListItem, 0);
        break;
    case ftBoolean:
        if (ListItem == "True")
          pParam->AsBoolean = true;
        else
          pParam->AsBoolean = false;
        break;
    case ftFloat:
        pParam->AsFloat = StrToFloat(ListItem);
        break;
    case ftCurrency:
        pParam->AsCurrency = StrToFloat(ListItem);
        break;
    case ftBCD:
        pParam->AsBCD = StrToCurr(ListItem);
        break;
    case ftDate:
        pParam->AsDate = StrToDate(ListItem);
        break;
    case ftTime:
        pParam->AsTime = StrToTime(ListItem);
        break;
    case ftDateTime:
        pParam->AsDateTime = StrToDateTime(ListItem);
        break;
  }
} 
