//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FileExists.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: FileExists
// Routine: SysUtils.FileExists
// Routine: SysUtils.DeleteFile
// Routine: SysUtils.ExtractFilePath

// BeginCode
/*
The following code prompts for confirmation before deleting
a file.  Create a file and then click on the button to select
the file with a TOpenDialog.  Click Yes to delete it.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  OpenDialog1->Title = "Delete File";
  if (OpenDialog1->Execute())
  {
	if (FileExists(OpenDialog1->FileName))
	{
	  if (MessageDlg(
		("Do you really want to delete " + ExtractFileName(OpenDialog1->FileName) + "?"),
		mtConfirmation,
		TMsgDlgButtons() << mbYes << mbNo,
		0,
		mbNo) == mrYes)
		DeleteFile(OpenDialog1->FileName);
	}
	else
	  MessageDlg(("File " + ExtractFileName(OpenDialog1->FileName) + " does not exist."), mtConfirmation, TMsgDlgButtons() << mbOK, 0);
  }
}
// EndCode
// EndExample: FileExists
//---------------------------------------------------------------------------
