/*
The following code reads a file's attributes into a set
variable, sets the check boxes in a file-attribute dialog
box to represent the current attributes, then executes the
dialog box. If the user changes and accepts any dialog box
settings, the code sets the file attributes to match the
changed settings:
*/
void __fastcall TFormMain::Properties1Click(TObject *Sender)
{

  unsigned short  Attributes;
  unsigned short  NewAttributes;

  FileAttrDlg->FileDirName->Caption = FileList->Items->Strings[FileList->ItemIndex];
  FileAttrDlg->FilePathName->Caption = FileList->Directory;
  FileAttrDlg->ChangeDate->Caption = DateTimeToStr(FileDateToDateTime(FileAge(FileList->FileName)));
  Attributes = FileGetAttr(FileList->Items->Strings[FileList->ItemIndex]);
  FileAttrDlg->ReadOnly->Checked = Attributes & faReadOnly;
  FileAttrDlg->Archive->Checked = Attributes & faArchive;
  FileAttrDlg->System->Checked = Attributes & faSysFile;
  FileAttrDlg->Hidden->Checked = Attributes & faHidden;
  if (FileAttrDlg->ShowModal()!= mrCancel){
     NewAttributes = Attributes;
     if (FileAttrDlg->ReadOnly->Checked)
       NewAttributes = NewAttributes | faReadOnly;
     else
		NewAttributes = NewAttributes & ~faReadOnly;

     if (FileAttrDlg->Archive->Checked)
       NewAttributes = NewAttributes | faArchive;
     else
       NewAttributes = NewAttributes & ~faArchive;

     if (FileAttrDlg->System->Checked)
       NewAttributes = NewAttributes | faSysFile;
     else
       NewAttributes = NewAttributes & ~faSysFile;

     if (FileAttrDlg->Hidden->Checked)
       NewAttributes = NewAttributes | faHidden;
     else
       NewAttributes = NewAttributes  & ~faHidden;
     if (NewAttributes != Attributes)
       FileSetAttr(FileAttrDlg->FileDirName->Caption, NewAttributes);
  }
}

