//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FileListBox.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: FileListBox
// Property: StdCtrls.TCustomListBox.Items
// Property: StdCtrls.TCustomListBox.Selected
// AnsiString

// BeginCode
/*
This example uses a file listbox and a regular listbox on a
form. The following routine scans through the files listed
in the file listbox and lists the sizes of any selected
files to the regular list box.  To exercise the error
condition create a file in the Debug directory, start this
application and then delete the file.  Now try to list the
size of the deleted file.  Continue will continue listing
file sizes in a multiple selection that includes the deleted
file.  Break will stop.  Set the MultiSelect and
ExtendedSelect properties on the FileListBox.
*/
#include <stdio.h>     // for FILE, fopen, fstat, fileno, fread and fclose
#include <sys\stat.h>  // for fstat and the stat struct

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  for (int i = 0; i < FileListBox1->Items->Count; i++)
  {
	if (FileListBox1->Selected[i])
	{
	  if (!FileExists(FileListBox1->Items->Strings[i]))
	  {
		MessageBeep(0);
		if (Application->MessageBox(
		  String("File " + FileListBox1->Items->Strings[i] + "not found").c_str(),
		  NULL,
		  MB_OKCANCEL) == IDCANCEL)
		  break;
		else
		  continue;
	  }
	  FILE *F = fopen(AnsiString(FileListBox1->Items->Strings[i]).c_str(),"r");
	  struct stat statbuf;
	  fstat(fileno(F), &statbuf);
	  ListBox1->Items->Add(
		  FileListBox1->Items->Strings[i] + ": " + IntToStr(int(statbuf.st_size)));
	  fclose(F);
	}
  }
}
// EndCode
// EndExample: FileListBox
//---------------------------------------------------------------------------

