//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FileToGrid.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: FileToGrid
// Routine: SysUtils.FileExists
// Routine: SysUtils.FileOpen
// Routine: SysUtils.FileSeek
// Routine: SysUtils.FileRead
// Routine: SysUtils.FileWrite
// Routine: SysUtils.FileClose


// BeginCode
/*
The following example uses a button, a string grid, and an
Open dialog box on a form. When the button is clicked, the
user is prompted for a filename. When the user clicks OK,
the specified file is opened, read into a buffer, and closed.
Then the buffer is displayed in two columns of the string
grid. The first time you use this app, you should do a "Fill
Grid" and then "Write Grid to File".   Always use files
generated in this way to do a "Read File into Grid".
*/
// Read File to Grid

#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  int iFileHandle;
  int iFileLength;
  int iBytesRead;
  int iLength;
  if (OpenDialog1->Execute())
  {
	try
	{
	  iFileHandle = FileOpen(OpenDialog1->FileName, fmOpenRead);
      iFileLength = FileSeek(iFileHandle,0,2);
	  FileSeek(iFileHandle,0,0);
	  iBytesRead = FileRead(iFileHandle, reinterpret_cast<char *>(&(StringGrid1->ColCount)), 4);
	  iBytesRead = FileRead(iFileHandle, reinterpret_cast<char *>(&(StringGrid1->RowCount)), 4);
	  for (int x = 0; x < StringGrid1->ColCount; x++)
	  {
		for (int y = 0; y < StringGrid1->RowCount; y++)
		{
		  // Write out the length of each string, followed by the string itself.
		  FileRead(iFileHandle, reinterpret_cast<char *>(&iLength), 4);
		  std::auto_ptr<AnsiChar> pszBuffer(new AnsiChar[iLength + 1]);
		  FileRead(iFileHandle, pszBuffer.get(), iLength);
		  pszBuffer.get()[iLength] = 0;
		  StringGrid1->Cells[x][y] = pszBuffer.get();
		}
	  }
	  FileClose(iFileHandle);
	}
    catch(...)
	{
#if defined(_DELPHI_STRING_UNICODE)
	  Application->MessageBox(
		L"Can't perform one of the following file operations: Open, Seek, Read, Close.",
		L"File Error",
		IDOK);
#else
	  Application->MessageBox(
		"Can't perform one of the following file operations: Open, Seek, Read, Close.",
		"File Error",
		IDOK);
#endif
	}
  }
}

// Write Grid into File

#include <dir.h>

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  char szFileName[MAXFILE+4];
  int iFileHandle;
  int iLength;
  if (SaveDialog1->Execute())
  {
	if (FileExists(SaveDialog1->FileName))
    {
	  fnsplit(AnsiString(SaveDialog1->FileName).c_str(), 0, 0, szFileName, 0);
	  strcat(szFileName, ".BAK");
      RenameFile(SaveDialog1->FileName, szFileName);
    }
    iFileHandle = FileCreate(SaveDialog1->FileName);
    // Write out the number of rows and columns in the grid.
	FileWrite(iFileHandle, reinterpret_cast<char *>(&(StringGrid1->ColCount)), sizeof(StringGrid1->ColCount));
    FileWrite(iFileHandle, reinterpret_cast<char *>(&(StringGrid1->RowCount)), sizeof(StringGrid1->RowCount));
	for (int x=0;x<StringGrid1->ColCount;x++)
	{
	  for (int y=0;y<StringGrid1->RowCount;y++)
	  {
		// Write out the length of each string, followed by the string itself.
		iLength = StringGrid1->Cells[x][y].Length();
		FileWrite(iFileHandle, (AnsiChar *)&iLength, sizeof(iLength));
		FileWrite(iFileHandle, StringGrid1->Cells[x][y].t_str(), StringGrid1->Cells[x][y].Length());
	  }
	}
	FileClose(iFileHandle);
  }
}
// EndCode
// EndExample: FileToGrid

// Clear Grid
void __fastcall TForm1::Button3Click(TObject *Sender)
{
  for (int x=0;x<StringGrid1->ColCount;x++)
  {
	for (int y=0;y<StringGrid1->RowCount;y++)
	{
	  StringGrid1->Cells[x][y] = "";
	}
  }
}

// Fill Grid
void __fastcall TForm1::Button4Click(TObject *Sender)
{
  StringGrid1->Cells[1][0] = "Column 1";
  StringGrid1->Cells[2][0] = "Column 2";
  StringGrid1->Cells[3][0] = "Column 3";
  StringGrid1->Cells[4][0] = "Column 4";
  StringGrid1->Cells[0][1] = "Row 1";
  StringGrid1->Cells[1][1] = "Object";
  StringGrid1->Cells[2][1] = "Pascal";
  StringGrid1->Cells[3][1] = "is";
  StringGrid1->Cells[4][1] = "excellent";
  StringGrid1->Cells[0][2] = "Row 2";
  StringGrid1->Cells[1][2] = "Delphi";
  StringGrid1->Cells[2][2] = "is";
  StringGrid1->Cells[4][2] = "RAD";
}

int currCellCol, currCellRow;

void __fastcall TForm1::StringGrid1MouseUp(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
  StringGrid1->MouseToCell(X, Y, currCellCol, currCellRow);
}

// Alter Cell
void __fastcall TForm1::Button5Click(TObject *Sender)
{
  StringGrid1->Cells[currCellCol][currCellRow] = Edit1->Text;
}
//---------------------------------------------------------------------------
