//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FilterIndex.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: FilterIndex
// Property: Dialogs.TOpenDialog.FilterIndex
// Property: Dialogs.TOpenDialog.Files
// Property: Classes.TStrings.Strings
// Method: Classes.TStrings.Append

// BeginCode
/*
This example uses an Open dialog box, a memo, and a button
on a form. When the user clicks the button, the Open dialog
box appears. When the user selects files in the dialog box
and chooses the OK button, the first line from each of the
files is added to the memo. Choose multiple files using the
CNTL key or the SHIFT key.
*/

#include <stdio.h>     // for FILE

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  FILE *stream;
  char FirstLine[512];
  
  OpenDialog1->Options.Clear();
  OpenDialog1->Options << ofAllowMultiSelect << ofFileMustExist;
  OpenDialog1->Filter = "Text files (*.txt)|*.txt|All files (*.*)|*.*";
  OpenDialog1->FilterIndex = 2; // start the dialog showing all files 
  if (OpenDialog1->Execute())
  {
    for (int I = 0; I < OpenDialog1->Files->Count; I ++)
    {
	  stream = fopen(AnsiString(OpenDialog1->Files->Strings[I]).c_str(), "r");
      if (stream)
      {
        // read the first line from the file
        fgets(FirstLine, sizeof(FirstLine), stream);
        Memo1->Lines->Append(FirstLine);
        fclose(stream);
      }
    }
  }
}
// EndCode
// EndExample: FilterIndex
//---------------------------------------------------------------------------
