/*
FindComponent example
The following example creates 20 edit boxes, using FindComponent with the edit box name to access each newly created edit box.
*/ 
const int EditBoxCount = 20;
const int LeftCoordinate = 10;
TForm1 *Form1;
TEdit* pe[20];
void __fastcall TForm1::FormCreate(TObject *Sender)
{
    const char* pszNamePrefix = "MyEdit";
    for (int i=0;i<EditBoxCount;i++)
    {
        pe[i] = new TEdit(this);
        pe[i]->Name = pszNamePrefix + IntToStr(i+1);
        pe[i]->Left = LeftCoordinate;
        pe[i]->Top = i*EditBoxCount;
        pe[i]->Parent = this;
    }

    delete pszNamePrefix;
}
void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  for (int i=0;i<EditBoxCount;i++)
    delete pe[i];
} 
