//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FindField.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
#include <DBTables.hpp>
TForm1 *Form1;
TTable *Customers;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Customers = new TTable(Form1);
  Customers->Active = false; // The Table component must not be active
  Customers->DatabaseName = "DBDEMOS";
  Customers->TableType = ttParadox;
  Customers->TableName = "CustInfo";
  if (Customers->Exists)
	MessageDlg("CustInfo table already exists.", mtWarning, TMsgDlgButtons() << mbOK, 0);
  else // Don't overwrite an existing table
  {
	// describe the fields in the table
	Customers->FieldDefs->Clear();
	TFieldDef *newDef = Customers->FieldDefs->AddFieldDef();
	newDef->Name = "Field1";
	newDef->DataType = ftInteger;
	newDef->Required = true;
	newDef = Customers->FieldDefs->AddFieldDef();
	newDef->Name = "Field2";
	newDef->DataType = ftString;
	newDef->Size = 30;
	// Next, describe any indexes
	Customers->IndexDefs->Clear();
	/* the 1st index has no name because it is a Paradox primary key */
	Customers->IndexDefs->Add("","Field1", TIndexOptions() <<ixPrimary << ixUnique);
	Customers->IndexDefs->Add("Fld2Index", "Field2", TIndexOptions() << ixCaseInsensitive);
	// Now that we have specified what we want, create the table
	Customers->CreateTable();
	Customers->Active = True;
	for (int i = 1; i <= 20; i++)
	  Customers->AppendRecord(ARRAYOFCONST((i*111, i*222)));
  }
  DS2->DataSet = Customers;
  DBGrid2->DataSource->DataSet = Customers;
  Customers->Active = True;
  DS2->OnDataChange = DS2DataChange;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  Customers->Close();
  Customers->DeleteTable();
}
//---------------------------------------------------------------------------
// BeginExample: FindField
// Method: DB.TDataSet.FindField
// Method: DB.TField.AsString
// Event: DB.TDataSource.OnDataChange

// BeginCode
/*
This example uses a button to copy the value of a field in
the previous record into the corresponding field in the
current record.  The field to copy is specified by using
FindField and the name of the field.
*/
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  TBookmark SavePlace;
  Variant PrevValue;
  // get a bookmark so that we can return to the same record
  SavePlace = Customers->GetBookmark();
  try
  {
	// move to prior record}
	Customers->FindPrior();
	// get the value
	// This is the safe way to get 'CustNo' field
	PrevValue = Customers->FindField("Field2")->Value;
	// This is *not* the safe way to change 'CustNo' field
	// PrevValue = Customers->Fields->Fields[1]->Value;
/*
	Move back to the bookmark
	this may not be the next record anymore
	if something else is changing the dataset asynchronously
*/
	Customers->GotoBookmark(SavePlace);
	// Set the value
	Customers->Edit();
	// This is the safe way to change 'CustNo' field
	Customers->FindField("Field2")->AsString = PrevValue;
	// This is *not* the safe way to change 'CustNo' field
	// Customers->Fields->Fields[1]->AsString = PrevValue;
	// Free the bookmark
  }
  __finally
  {
	Customers->FreeBookmark(SavePlace);
  };
}

/*
To ensure that the button is disabled when there is no
previous record, the OnDataChange event of the DataSource
detects when the user moves to the beginning of file (BOF
property becomes true), and disables the button.  Detection
occurs on scrolling and editing, not selection with the mouse.
*/
void __fastcall TForm1::DS2DataChange(TObject *Sender, TField *Field)
{
  if (Customers->Bof)
	Button2->Enabled = False;
  else
	Button2->Enabled = True;
}
// EndCode
// EndExample: FindField
//---------------------------------------------------------------------------

