//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FindFirst.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: FindFirst
// Routine: SysUtils.FindFirst
// Routine: SysUtils.FindNext
// Routine: SysUtils.FindClose
// Type: SysUtils.TSearchRec

// BeginCode
/*
The following example uses an edit control, a button, a
string grid, and seven check boxes. The check boxes
correspond to the seven possible file attributes. When the
button is clicked, the path specified in the edit control is
searched for files matching the checked file attributes. The
names and sizes of the matching files are inserted into the
string grid.  The Path constant parameter is the directory
and file name mask, including wildcard characters. For
example, '.\test\*.*' specifies all files in the current
directory. Click at least one box before clicking the button.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TSearchRec sr;
  int iAttributes = 0;
  StringGrid1->RowCount = 1;
  iAttributes |= faReadOnly * CheckBox1->Checked;
  iAttributes |= faHidden * CheckBox2->Checked;
  iAttributes |= faSysFile * CheckBox3->Checked;
  iAttributes |= faVolumeID * CheckBox4->Checked;
  iAttributes |= faDirectory * CheckBox5->Checked;
  iAttributes |= faArchive * CheckBox6->Checked;
  iAttributes |= faAnyFile * CheckBox7->Checked;
  StringGrid1->RowCount = 0;
  if (FindFirst(Edit1->Text, iAttributes, sr) == 0)
  {
    do
    {
      if ((sr.Attr & iAttributes) == sr.Attr)
      {
        StringGrid1->RowCount = StringGrid1->RowCount + 1;
        StringGrid1->Cells[1][StringGrid1->RowCount-1] = sr.Name;
        StringGrid1->Cells[2][StringGrid1->RowCount-1] = IntToStr(sr.Size);
      }
    } while (FindNext(sr) == 0);
    FindClose(sr);
  }
}
// EndCode
// EndExample: FindFirst
//---------------------------------------------------------------------------
