//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FindText.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: FindText
// Property: Dialogs.TFindDialog.Position
// Method: Dialogs.TFindDialog.Execute
// Method: ComCtrls.TCustomRichEdit.FindText
// Property: Dialogs.TFindDialog.FindText
// Event: Dialogs.TFindDialog.OnFind
// Property: StdCtrls.TCustomEdit.SelStart
// Property: StdCtrls.TCustomEdit.SelLength
// Property: Dialogs.TFindDialog.Options
// Class: ComCtrls.TSearchTypes
// Routine: SysUtils.Beep
// Type: Dialogs.TFindOptions

// BeginCode
/*
This example requires a TRichEdit, a TButton, and a 
TFindDialog.  Clicking the button will display a Find
Dialog to the right of the edit control.  Filling in the 
"Find what" text and pressing the Find Next button will
select the first matching string in the Rich Edit control 
that follows the previous selection. Notice that the
"Match whole word only" and "Match case" work.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  FindDialog1->Position = Point(RichEdit1->Left + RichEdit1->Width, RichEdit1->Top);
  FindDialog1->Execute();
}

void __fastcall TForm1::FindDialog1Find(TObject *Sender)
{
  int FoundAt, StartPos, ToEnd;
  TSearchTypes mySearchTypes = TSearchTypes();
  // begin the search after the current selection
  // if there is one
  // otherwise, begin at the start of the text
  if (FindDialog1->Options.Contains(frMatchCase))
	mySearchTypes << stMatchCase;
  if (FindDialog1->Options.Contains(frWholeWord))
	mySearchTypes << stWholeWord;
  if (RichEdit1->SelLength)
	StartPos = RichEdit1->SelStart + RichEdit1->SelLength;
  else
	StartPos = 0;
  // ToEnd is the length from StartPos
  // to the end of the text in the rich edit control
  ToEnd = RichEdit1->Text.Length() - StartPos;
  FoundAt = RichEdit1->FindText(FindDialog1->FindText, StartPos, ToEnd, mySearchTypes);
  if (FoundAt != -1)
  {
	RichEdit1->SetFocus();
	RichEdit1->SelStart = FoundAt;
	RichEdit1->SelLength = FindDialog1->FindText.Length();
  }
  else Beep();
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichEdit1->PlainText = False;
  RichEdit1->Lines->LoadFromFile("../Overview.RTF");  // starts in Debug
  RichEdit1->ScrollBars = ssVertical;
}
// EndCode
// EndExample: FindText
//---------------------------------------------------------------------------
