/*
Position, Execute, FindText, OnFind, SelStart, SelLength example
This example requires a TRichEdit, a TButton, and a TFindDialog.
Clicking the button click will display a Find Dialog to the right of the edit control.  Filling in the "Find what" text and pressing the Find Next button will select the first matching string in the Rich Edit control that follows the previous selection.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  FindDialog1->Position = Point(RichEdit1->Left + RichEdit1->Width, RichEdit1->Top);
  FindDialog1->Execute();
}
void __fastcall TForm1::FindDialog1Find(TObject *Sender)
{
  int FoundAt, StartPos, ToEnd;
  // begin the search after the current selection 
  // if there is one 
  // otherwise, begin at the start of the text 
  if (RichEdit1->SelLength)
    StartPos = RichEdit1->SelStart + RichEdit1->SelLength;
  else
    StartPos = 0;
  // ToEnd is the length from StartPos 
  // to the end of the text in the rich edit control
  ToEnd = RichEdit1->Text.Length() - StartPos;
  FoundAt = RichEdit1->FindText(FindDialog1->FindText, StartPos, ToEnd, TSearchTypes()<< stMatchCase);
  if (FoundAt != -1)
  {
    RichEdit1->SetFocus();
    RichEdit1->SelStart = FoundAt;
    RichEdit1->SelLength = FindDialog1->FindText.Length();
  }
}
 
