//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FirstIndent.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: FirstIndent
// Property: ComCtrls.TCustomRichEdit.Lines
// Property: ComCtrls.TCustomRichEdit.Paragraph
// Property: ComCtrls.TParaAttributes.FirstIndent
// Property: ComCtrls.TParaAttributes.Numbering
// Type: Controls.TAlign
// Enumeration: ComCtrls.TNumberingStyle
// Enumeration: Classes.TAlignment

// BeginCode
/*
This example requires only a form.  A Rich Edit control is
created on the form and aligned to take the entire client
area of the form.  A series of lines are written to the Rich
Edit control's Lines property, and the Paragraph property
manipulated such that the first items displayed are bulleted,
a second group of lines are unbulleted and centered, and the
last group is left justified and indented.
*/
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TRichEdit *pRich = new TRichEdit(this);  // The owner will clean this up.
  pRich->Parent = this;
  pRich->Align = alClient;
  pRich->Lines->Clear();
  // set numbering style
  pRich->Paragraph->Numbering = nsBullet;
  pRich->Lines->Add("Introduction");
  pRich->Lines->Add("New members to our team");
  pRich->Lines->Add("New Budget discussion");
  pRich->Lines->Add("Facilities");
  pRich->Lines->Add("Q & A");
  pRich->Paragraph->Numbering = nsNone;
  pRich->Paragraph->Alignment = taCenter;
  pRich->Lines->Add("");
  pRich->Lines->Add("Suggested Topics: ");
  pRich->Lines->Add("");
  pRich->Paragraph->Alignment = taLeftJustify;
  pRich->Paragraph->FirstIndent = 10;
  pRich->Lines->Add("");
  pRich->Lines->Add("Parking lot repair");
  pRich->Lines->Add("Cost overruns");
}
// EndCode
// EndExample: FirstIndent
//---------------------------------------------------------------------------
