/*
Lines, Paragraph, FirstIndent, Numbering example
This example requires only a form.
A Rich Edit control is created on the form and aligned to take the entire client area of the form.  A series of lines are written to the Rich Edit control's Lines property, and the Paragraph property manipulated such that the first items displayed are bulleted, a second group of lines are unbulleted and centered, and the last group is left justified and indented.
*/ 
#include <ComCtrls.hpp>;

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TRichEdit *pRich = new TRichEdit(this);
  pRich->Parent = this;
  pRich->Align = alClient;
  pRich->Lines->Clear();
  // set numbering style
  pRich->Paragraph->Numbering = nsBullet;
  pRich->Lines->Add("Introduction");
  pRich->Lines->Add("New members to our team");
  pRich->Lines->Add("New Budget discussion");
  pRich->Lines->Add("Facilities");
  pRich->Lines->Add("Q & A");
  pRich->Paragraph->Numbering = nsNone;
  pRich->Paragraph->Alignment = taCenter;
  pRich->Lines->Add("");
  pRich->Lines->Add("Suggested Topics: ");
  pRich->Lines->Add("");
  pRich->Paragraph->Alignment = taLeftJustify;
  pRich->Paragraph->FirstIndent = 10;
  pRich->Lines->Add("");
  pRich->Lines->Add("Parking lot repair");
  pRich->Lines->Add("Cost overruns");
}
 
