//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FlowPanels_cpp.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

// BeginExample: FlowPanels
// Class: ExtCtrls.TFlowPanel
// Property: ExtCtrls.TCustomFlowPanel.FlowStyle
// Enumeration: ExtCtrls.TFlowStyle
// Class: Contnrs.TObjectStack
// Method: Contnrs.TObjectStack.Push
// Method: Contnrs.TObjectStack.Pop
// Method: Contnrs.TObjectStack.Peek
// BeginCode
//
//This example demonstrates the use of Flow panel to automatically
//align a set of controls and the different methods that can be used for that.
//A Stack is used to control the order of destruction of buttons.
//
void __fastcall TForm2::btAButtonClick(TObject *Sender)
{
	TButton *thisButton;
	TButton *lastButton;
	String temp;

	/* Sender is a TButton, cast it */
	thisButton = dynamic_cast<TButton*>(Sender);

	if (m_Stack->Count() > 0)
	{
		/* If there are buttons in stack, peek it */
		lastButton = dynamic_cast<TButton*>(m_Stack->Peek());

		/* Change the captions of this button and the last one */
		temp = thisButton->Caption;
		thisButton->Caption = lastButton->Caption;
		lastButton->Caption = temp;
	}
}

void __fastcall TForm2::btAddButtonClick(TObject *Sender)
{
	/* Create a new button */
	TButton *button = new TButton(m_FlowPane);

	button->Parent = m_FlowPane;
	button->Caption = IntToStr(m_Stack->Count());
	button->OnClick = btAButtonClick;

	/* Push the button to the stack */
	m_Stack->Push(button);
}

void __fastcall TForm2::btReArrangeClick(TObject *Sender)
{
	/* Change the current flow style (rotate them) */
	TFlowStyle newFlowStyle = m_FlowPane->FlowStyle;

	if (newFlowStyle == fsBottomTopRightLeft)
		newFlowStyle = fsLeftRightTopBottom;
	else
		newFlowStyle = newFlowStyle + 1;

	m_FlowPane->FlowStyle = newFlowStyle;
}

void __fastcall TForm2::btRemoveButtonClick(TObject *Sender)
{
	TButton *button;

	if (m_Stack->Count() > 0)
	{
		/* if the stack is not empty, pop the last button */
		button = dynamic_cast<TButton*>(m_Stack->Pop());
		delete button;
    }
}

void __fastcall TForm2::FormCreate(TObject *Sender)
{
	/* Create a new TFlowPanel pane and align it to client */
	m_FlowPane = new TFlowPanel(this);
	m_FlowPane->Parent = this;
	m_FlowPane->Align = alClient;

	/* Set the initial flowing style */
	m_FlowPane->FlowStyle = fsLeftRightTopBottom;

	/* Create the button stack */
	m_Stack = new TObjectStack();
}

void __fastcall TForm2::FormDestroy(TObject *Sender)
{
	/* Destroy the stack also */
	delete m_Stack;
}
// EndCode
// EndExample: FlowPanels
//---------------------------------------------------------------------------
