//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FontDialogOnApply.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

// BeginExample: FontDialogOnApply
// Property: Dialogs.TFontDialog.Font
// Method: Dialogs.TFontDialog.Execute
// Event: Dialogs.TFontDialog.OnApply
// Method: Graphics.TFont.Assign
// Method: ComCtrls.TTextAttributes.Assign
// Event: Controls.TWinControl.OnEnter

// BeginCode
/*
This example takes an edit control, a button, and a rich
edit control on a form.  When the user presses the button, a
Font dialog appears.  When the user clicks the Apply (not OK)
button in the Font dialog, the currently selected font is
applied to the active control. Clicking the button sets the
ActiveControl to the button.  That is why we need to save
the ActiveControl in a shared OnEnter procedure.  In the rich
edit, only the text selected converts.
*/
TWinControl *myActiveControl;

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  FontDialog1->Options << fdApplyButton;
  FontDialog1->Execute();
}

void __fastcall TForm1::FontDialog1Apply(TObject *Sender, HWND Wnd)
{
  if (myActiveControl->ClassNameIs("TEdit"))
   (dynamic_cast<TEdit *>(myActiveControl))->Font->Assign(FontDialog1->Font);
  else if (myActiveControl->ClassNameIs("TRichEdit"))
	(dynamic_cast<TRichEdit *>(myActiveControl))->SelAttributes->Assign(FontDialog1->Font);
  else
    MessageBeep(0);
}

void __fastcall TForm1::Edit1Enter(TObject *Sender)
{
  myActiveControl = ActiveControl;
}
// EndCode
// EndExample: FontDialogOnApply
//---------------------------------------------------------------------------
