//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FormatCount.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}

// BeginExample: FormatCount
// Property: Clipbrd.TClipboard.FormatCount
// Property: Clipbrd.TClipboard.Formats

// BeginCode
/*
The following code adds each format on the Clipboard to
ListBox1 when Button1 is clicked.  Something must be on
the Clipboard for Formats to work.  Load the Clipboard
by doing a Paste in another window.

Note: You will need to add Clipbrd to the uses clause (Delphi)
or include <Clipbrd.hpp> (C++).
*/
#include <clipbrd.hpp>
#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  for(int i=0; i < Clipboard()->FormatCount;i++)
    ListBox1->Items->Add(IntToStr(Clipboard()->Formats[i]));
}
// EndCode
// EndExample: FormatCount

void __fastcall TForm1::Button3Click(TObject *Sender)
{
  Graphics::TBitmap *Bitmap = new Graphics::TBitmap();
//  Image1->Picture->RegisterClipboardFormat(CF_BITMAP, TIcon);
  Bitmap->LoadFromClipboardFormat(
	CF_BITMAP, Clipboard()->GetAsHandle(CF_BITMAP), 0);
  Image1->Canvas->Draw(0, 0, Bitmap);

  delete Bitmap;
  Clipboard()->Clear();
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  unsigned int DataHandle;
  HPALETTE APalette;
  unsigned short MyFormat;
  std::auto_ptr<Graphics::TBitmap> Bitmap(new Graphics::TBitmap());
  try
  {
	Bitmap->LoadFromFile("C:\\Program Files\\Common Files\\CodeGear Shared\\Images\\Splash\\256Color\\FACTORY.BMP");
	// generate a clipboard format, with data and palette
	Bitmap->SaveToClipboardFormat(
	  MyFormat,
	  DataHandle,
	  APalette);
    // save the data to the clipboard using that format and
    // the generated data
    Clipboard()->SetAsHandle(MyFormat,DataHandle);
  }
  catch (...)
  {
	 ShowMessage("Failed to copy image to clipboard!");
  }
}
//---------------------------------------------------------------------------
