//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FormatFloat.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: FormatFloat
// Routine: SysUtils.FormatFloat
// Routine: SysUtils.StrToFloat

// BeginCode
/*
The following example uses two buttons, a string grid, and
text edit on a form. When the conversion button is clicked,
the values across the top of the string grid are converted
using the formats along the left side.  Select a cell and
use the Alter Cell button and text edit to change the
values converted and the conversion formats.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  for (int x = 1; x < StringGrid1->ColCount; x++)
  {
	for (int y = 1; y < StringGrid1->RowCount; y++)
	{
	  StringGrid1->Cells[x][y] = FormatFloat(
	  StringGrid1->Cells[0][y], StrToFloat(StringGrid1->Cells[x][0]));
	}
  }
}

int currCellCol, currCellRow;

void __fastcall TForm1::StringGrid1MouseUp(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
  StringGrid1->MouseToCell(X, Y, currCellCol, currCellRow);
}

// Alter Cell
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  StringGrid1->Cells[currCellCol][currCellRow] = Edit1->Text;
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  StringGrid1->Cells[1][0] = "1234";
  StringGrid1->Cells[2][0] = "-1234";
  StringGrid1->Cells[3][0] = "0.5";
  StringGrid1->Cells[4][0] = "0";
  StringGrid1->Cells[0][1] = "";
  StringGrid1->Cells[0][2] = "0";
  StringGrid1->Cells[0][3] = "0.00";
  StringGrid1->Cells[0][4] = "#.##";
  StringGrid1->Cells[0][5] = "#,##0.00";
  StringGrid1->Cells[0][6] = "#,##0.00;(#,##0.00)";
  StringGrid1->Cells[0][7] = "#,##0.00;;Zero";
  StringGrid1->Cells[0][8] = "0.000E+00";
  StringGrid1->Cells[0][9] = "#.###E-0";
}
// EndCode
// EndExample: FormatFloat
//---------------------------------------------------------------------------

