
(*
 Delphi Object and Component Reference
 GetBookmark, GotoBookmark, FreeBookmark, FindPrior, Value, OnDataChange, Bof example
This example uses a button to copy the value of a field in the previous record into the corresponding field in the current record.
*) 
void __fastcall TForm1::CopyDataClick(TObject *Sender)
{
  TBookmark SavePlace;
  Variant PrevValue;

  // get a bookmark so that we can return to the same record
  SavePlace = Customers->GetBookmark();
  Customers->FindPrior();// move to prior record
  PrevValue = Customers->Fields->Fields[0]->Value; // get the value
  // Move back to the bookmark 
  // this may not be the next record anymore 
  // if something else is changing the dataset asynchronously
  Customers->GotoBookmark(SavePlace);
  Customers->Fields->Fields[0]->Value = PrevValue; // set the value
  Customers->FreeBookmark(SavePlace);
}
To ensure that the button is disabled when there is no previous record, the OnDataChange event of the DataSource detects when the user moves to the beginning of file (BOF property becomes true), and disables the button.
*) 
void __fastcall TForm1::CustomersDataChange(TObject *Sender, TField *Field)
{
  CopyData->Enabled = !Customers->Bof;
} 
