
(*
 Delphi Object and Component Reference
# {bmc bm9.BMP} GetComponent, SetComponent example
This cross-platform example uses a button and a group box on a form. When the user clicks the button, the button is copied to the Clipboard and then retrieved from the Clipboard and placed in the new parent of the button, the group box. The name of the original button is changed to avoid having two components with the same name at the same time.
*) 
__fastcall TForm1::TForm1(TComponent* Owner): TForm(Owner)
{
  // Register the TButton class so that the clipboard can
  // read and write button objects
   TMetaClass *MetaClass = __classid(TButton);
   RegisterClasses(&MetaClass, 0);
}
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  // copy the button to the clipboard
  Clipboard()->SetComponent(Button1);
  // rename the button which is still on the form
  Button1->Name = "OriginalButton"; 
  // Now retrieve the button from the clipboard
  // and add it to GroupBox1 
  // Note that the clipboard button is named Button1,
  // while the source button has been renamed
  // to "OriginalButton" 
  Clipboard()->GetComponent(Self, GroupBox1);
} 
