/*
TCanvas, GetDeviceContext, Handle, Palette example
The GetFormImage allows you to easily obtain a bitmap of a form. The following method can be added to a custom TWinControl descendant to save itself as a bitmap.
*/
typedef struct {
  TLogPalette lpal;
  TPaletteEntry dummy[256];
} LogPal;
void __fastcall TMyControl::SaveAsBmp(TFileName fileName)
{
  TCanvas *tempCanvas = new TCanvas;
  try
  {
    HWND notUsed;
    tempCanvas->Handle = GetDeviceContext(notUsed);
    TImage *image2save = new TImage(Form1);
    try
    {
      image2save->Height = Height;
      image2save->Width = Width;
      TRect destRect = Rect(0,0,Width,Height);
      TRect sourceRect = destRect;
      image2save->Canvas->CopyRect(destRect, tempCanvas, sourceRect);
      LogPal SysPal;
      SysPal.lpal.palVersion = 0x300;
      SysPal.lpal.palNumEntries = 256;
      GetSystemPaletteEntries(tempCanvas->Handle,0,256,SysPal.lpal.palPalEntry);
      image2save->Picture->Bitmap->Palette = CreatePalette((const tagLOGPALETTE *)&SysPal.lpal);
      image2save->Picture->SaveToFile(fileName);
    }
    __finally
    {
     delete image2save;
    }
  }
  __finally
  {
    delete tempCanvas;
  }
} 
