//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "GetFormImage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: GetFormImage
// Method: Forms.TCustomForm.GetFormImage
// Property: ExtCtrls.TImage.Picture
// Method: Clipbrd.TClipboard.Assign
// Method: Graphics.TPicture.Assign

// BeginCode
/*
This example uses an image, a button, and a shape component
on a form. When the user clicks the button, an image of the
form is stored in the FormImage variable and copied to the
Clipboard. The image of the form is then copied back to
the image component, producing an interesting result,
especially if the button is clicked multiple times.  Add
ExtCtrls, StdCtrls, and Clipbrd to the uses clause.
}
*/

#include <Clipbrd.hpp>

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  Graphics::TBitmap *FormImage = GetFormImage();
  try
  {
	Clipboard()->Assign(FormImage);
	Image1->Picture->Assign(Clipboard());
  }
  __finally
  {
	delete FormImage;
  }
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Shape1->Shape = stEllipse;
  Shape1->Brush->Color = clLime;
  Image1->Stretch = true;
}
// EndCode
// EndExample: GetFormImage
//---------------------------------------------------------------------------

