//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "GetStaticRect.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}

// BeginExample: GetStaticRect
// Method: Dialogs.TOpenDialog.GetStaticRect
// Method: Dialogs.TCommonDialog.DoShow

// BeginCode
/*
The following example is taken from TOpenPictureDialog. It
calculates the preview rectangle based on the difference
between the client area of the dialog and the static area of
the standard controls.
*/

#include <ExtDlgs.hpp>

class MyOpenPictureDialog : public TOpenPictureDialog
{
private:	// User declarations
	TPanel *FPicturePanel;  // can't use the private versions in TOpenPictureDialog
	TLabel *FPictureLabel;
	TSpeedButton *FPreviewButton;
	TPanel *FPaintPanel;
	TImage *FImageCtrl;
	AnsiString FSavedFilename;
protected:	// User declarations
	DYNAMIC void __fastcall DoShow(void);
public:		// User declarations
	__fastcall MyOpenPictureDialog(TComponent* Owner);
	virtual bool __fastcall  Execute(HWND ParentWnd){ return TOpenDialog::Execute(ParentWnd); }
};

__fastcall MyOpenPictureDialog::MyOpenPictureDialog(TComponent* Owner)
	: TOpenPictureDialog(Owner)
{
}

#include <memory>       //for STL auto_ptr class

void __fastcall MyOpenPictureDialog::DoShow(void)
{
//  RECT *PreviewRect = new RECT();
  std::auto_ptr<RECT> PreviewRect(new RECT());
  TRect StaticRect;
  FPicturePanel = new TPanel(this); // the owner will clean this up
  FPictureLabel = new TLabel(this); // the owner will clean this up
  FPreviewButton = new TSpeedButton(this); // the owner will clean this up
  FPaintPanel = new TPanel(this); // the owner will clean this up
  FImageCtrl = new TImage(this); // the owner will clean this up
  // Set preview area to entire dialog
  GetClientRect(Handle, PreviewRect.get());
  StaticRect = GetStaticRect();
  // Move preview area to right of static area
  PreviewRect->left = StaticRect.Left + (StaticRect.Right - StaticRect.Left);
  PreviewRect->top += 4;
  FPicturePanel->BoundsRect.Left = PreviewRect->left;
  FPicturePanel->BoundsRect.Right = PreviewRect->right;
  FPicturePanel->BoundsRect.Top = PreviewRect->top;
  FPicturePanel->BoundsRect.Bottom = PreviewRect->bottom;

  FPreviewButton->Left = FPaintPanel->BoundsRect.Right - FPreviewButton->Width - 2;
  FImageCtrl->Picture = NULL;
  FSavedFilename = "";
  FPaintPanel->Caption = "";
  FPicturePanel->ParentWindow = Handle;
//  TOpenDialog::DoShow();   // the above code is equivalent to the inherited version
}

TForm1 *Form1;
MyOpenPictureDialog *OpenPictureDialog1;

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  if (OpenPictureDialog1->Execute(GetParentHandle()))
	  Image1->Picture->LoadFromFile(OpenPictureDialog1->FileName);
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  OpenPictureDialog1 =  new MyOpenPictureDialog(Form1); // the owner will clean this up
}
// EndCode
// EndExample: GetStaticRect
//---------------------------------------------------------------------------
