//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "HeaderSection.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: HeaderSection
// Event: ComCtrls.THeaderControl.OnDrawSection
// Property: ComCtrls.THeaderControl.Sections
// Property: ComCtrls.TCustomHeaderControl.Canvas
// Property: ComCtrls.THeaderSection.Style
// Property: ComCtrls.THeaderSection.Text
// Method: Graphics.TCanvas.TextOut
// Property: Graphics.TFont.Color

// BeginCode
/*
Add a THeaderControl to the form and call 
HeaderControl1DrawSection for the OnDrawSection event.
*/
void __fastcall TForm1::HeaderControl1DrawSection(THeaderControl *HeaderControl,
      THeaderSection *Section, const TRect &Rect, bool Pressed)
{
  if (Pressed)
	HeaderControl->Canvas->Font->Color = clRed;
  else
	HeaderControl->Canvas->Font->Color = clBlue;
  HeaderControl->Canvas->TextOut(Rect.Left + HeaderControl->Canvas->Font->Size, Rect.Top + 2, "Custom " + IntToStr(Section->Index));
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  THeaderSection *Section;
  for (int i = 0; i <= 4; i++)
  {
	Section = HeaderControl1->Sections->Add();
	Section->Text = "Section " + IntToStr(i);
	Section->MinWidth =
	  (Section->Text).Length() *
	  HeaderControl1->Font->Size;
	// Owner draw every other section
    if (i % 2 == 0)
	  Section->Style = hsOwnerDraw;
    else
      Section->Style = hsText;
  }
}
// EndCode
// EndExample: HeaderSection
//---------------------------------------------------------------------------
