{
HideScrollBars, ScrollBars example
This example requires: TRichEdit, TRadioGroup, TCheckBox, TButton. Clicking the Radio Group control sets the ScrollBar style of the RichEdit. Toggling the Check Box turns HideScrollBars on and off.  Clicking the button loads the Rich Edit with a large amount of contiguous text.
} 
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  RichEdit1->Lines->Clear();
  for (int i = 0; i < 500; i++)
    RichEdit1->Text = RichEdit1->Text + AnsiString("This is sentence ") + IntToStr(i) + ".  ";
  RichEdit1->SelStart = 0; // move text cursor to top of edit
}

void __fastcall TForm1::CheckBox1Click(TObject *Sender)
{
  RichEdit1->HideScrollBars = CheckBox1->Checked;
}

void __fastcall TForm1::RadioGroup1Click(TObject *Sender)
{
  TScrollStyle ScrollBarA[4] = {ssBoth, ssHorizontal, ssNone, ssVertical };
  RichEdit1->ScrollBars = ScrollBarA[RadioGroup1->ItemIndex];
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RadioGroup1->Caption = "Scroll Bars";
  RadioGroup1->Items->Clear();
  RadioGroup1->Items->Add("ssBoth");
  RadioGroup1->Items->Add("ssHorizontal");
  RadioGroup1->Items->Add("ssNone");
  RadioGroup1->Items->Add("ssVertical");
  CheckBox1->Caption = "Hide Scroll Bars";
  CheckBox1->Checked = true;
  Button1->Caption = "Load Text";
}
 
