//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "IndexOfName.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: IndexOfName
// Method: Classes.TStrings.IndexOfName
// Property: Classes.TStrings.Count
// Property: Classes.TStrings.Names
// Property: Classes.TStrings.Strings

// BeginCode
/*
The following example updates the strings in a list box
given the strings contained in another list box. If a string
in the source list box has the form Name=Value and the
destination list box contains a string with the same Name
part, the Value part in the destination list box will be
replaced by the sources value.  TListBox objects that are
not name-value pairs are not assigned a Name and IndexOfName
will return -1.  TStrings Values are referenced using the
name AnsiString as an index.
*/
void MergeStrings(TStrings *Dest, TStrings *Source)
{
  for (int i = 0; i < Source->Count; i++)
  {
    if (Source->Strings[i].Pos("=") > 1)
	{
	  int DI = Dest->IndexOfName(Source->Names[i]);
	  if (DI > -1)
		Dest->Values[Source->Names[i]] = Source->Values[Source->Names[i]];
	}
  }
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  MergeStrings(ListBox1->Items,ListBox2->Items);
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  ListBox1->Items->Add("Plants = 10");
  ListBox1->Items->Add("Animals = 20");
  ListBox1->Items->Add("Minerals = 15");
  ListBox2->Items->Add("Animals = 4");
  ListBox2->Items->Add("Plants = 3");
  ListBox2->Items->Add("Minerals = 78");
}
// EndCode
// EndExample: IndexOfName
//---------------------------------------------------------------------------
