//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "IniFiles_cpp.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

// BeginExample: IniFilesTMemIniFile
// Class: Registry.TRegistryIniFile
// Class: IniFiles.TIniFile
// Class: IniFiles.TMemIniFile
// Class: IniFiles.TCustomIniFile
// Method: IniFiles.TCustomIniFile.ReadInteger
// Method: IniFiles.TCustomIniFile.ReadString
// Method: IniFiles.TCustomIniFile.ReadBool
// Method: IniFiles.TCustomIniFile.WriteInteger
// Method: IniFiles.TCustomIniFile.WriteString
// Method: IniFiles.TCustomIniFile.WriteBool
// Method: IniFiles.TIniFile.ReadString
// Method: IniFiles.TIniFile.WriteString
// Method: IniFiles.TMemIniFile.ReadString
// Method: IniFiles.TMemIniFile.WriteString
// Method: Registry.TRegistryIniFile.ReadInteger
// Method: Registry.TRegistryIniFile.ReadString
// Method: Registry.TRegistryIniFile.WriteInteger
// Method: Registry.TRegistryIniFile.WriteString
// BeginCode
/*
This example demonstrates the usage of Ini files in order to store
and load form configuration between sessions. Example assumes
a RadioGroup and two buttons are present on the main form.
*/
void __fastcall TForm2::btStoreClick(TObject *Sender)
{
	/* Open an instance */
	TCustomIniFile* SettingsFile = OpenIniFileInstance();

	// Store current form properties to be used in later sessions.
	try
	{
		SettingsFile->WriteInteger (Name, "Top", Top);
		SettingsFile->WriteInteger (Name, "Left", Left);
		SettingsFile->WriteInteger (Name, "Width", Width);
		SettingsFile->WriteInteger (Name, "Height", Height);
		SettingsFile->WriteString  (Name, "Caption", Caption);
		SettingsFile->WriteBool    (Name, "InitMax", WindowState == wsMaximized );
	}
	catch(Exception* e)
	{
	}

	delete SettingsFile;
}

void __fastcall TForm2::btLoadClick(TObject *Sender)
{
	/* Open an instance */
	TCustomIniFile* SettingsFile = OpenIniFileInstance();

	try
	{
		/*
		Read all saved values from the last session. The section name
		is the name of the form. Also use form's properties as defaults
		*/
		Top     = SettingsFile->ReadInteger(Name, "Top", Top );
		Left    = SettingsFile->ReadInteger(Name, "Left", Left );
		Width   = SettingsFile->ReadInteger(Name, "Width", Width );
		Height  = SettingsFile->ReadInteger(Name, "Height", Height );
		Caption = SettingsFile->ReadString (Name, "Caption", Caption);

		// Load last window state
		if (SettingsFile->ReadBool(Name, "InitMax", WindowState == wsMaximized))
			WindowState = wsMaximized;
		else
			WindowState = wsNormal;
	}
	catch(Exception* e)
	{
	}

	delete SettingsFile;
}

TCustomIniFile* __fastcall TForm2::OpenIniFileInstance()
{
	/*
	Open/create a new INI file that has the same name as our executable
	only with the INI extension.
	*/

	switch (RadioGroup1->ItemIndex)
	{
		case 0:
			/* Registry mode selected: in HKEY_CURRENT_USER\Software\... */
			return new TRegistryIniFile(String("Software\\") + Application->Title);
		case 1:
			/* Ini file mode selected */
			return new TIniFile(ChangeFileExt(Application->ExeName, ".INI"));
		case 2:
			/* Memory based Ini file mode selected */
			return new TMemIniFile(ChangeFileExt(Application->ExeName, ".INI"));
	  }
}
// EndCode
// EndExample: IniFilesTMemIniFile
//---------------------------------------------------------------------------
